/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.ssl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.mule.config.i18n.Message;
import org.mule.providers.tcp.TcpConnector;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.security.provider.AutoDiscoverySecurityProviderFactory;
import org.mule.umo.security.provider.SecurityProviderFactory;
import org.mule.umo.security.provider.SecurityProviderInfo;
import org.mule.util.FileUtils;
import org.mule.util.IOUtils;

public class SslConnector
extends TcpConnector {
    public static final String DEFAULT_KEYSTORE_TYPE = KeyStore.getDefaultType();
    private SecurityProviderFactory spFactory = new AutoDiscoverySecurityProviderFactory();
    private SecurityProviderInfo spInfo = this.spFactory.getSecurityProviderInfo();
    private String keyStore = null;
    private String keyPassword = null;
    private String storePassword = null;
    private String keyStoreType = DEFAULT_KEYSTORE_TYPE;
    private String keyManagerAlgorithm = this.spInfo.getKeyManagerAlgorithm();
    private Provider provider = this.spFactory.getProvider();
    private String protocolHandler = this.spInfo.getProtocolHandler();
    private String clientKeyStore = null;
    private String clientKeyStorePassword = null;
    private String trustStore = null;
    private String trustStorePassword = null;
    private String trustStoreType = DEFAULT_KEYSTORE_TYPE;
    private String trustManagerAlgorithm = this.spInfo.getKeyManagerAlgorithm();
    private TrustManagerFactory trustManagerFactory;
    private boolean explicitTrustStoreOnly = false;
    private KeyManagerFactory keyManagerFactory = null;
    private boolean requireClientAuthentication = true;

    public void doInitialise() throws InitialisationException {
        InputStream is;
        if (this.getProvider() == null) {
            throw new NullPointerException("The security provider cannot be null");
        }
        if (this.getKeyStore() != null) {
            if (this.getKeyPassword() == null) {
                throw new NullPointerException("The Key password cannot be null");
            }
            if (this.getStorePassword() == null) {
                throw new NullPointerException("The KeyStore password cannot be null");
            }
            if (this.getKeyManagerAlgorithm() == null) {
                throw new NullPointerException("The Key Manager Algorithm cannot be null");
            }
            if (this.getKeyStoreType() == null) {
                throw new NullPointerException("The KeyStore type cannot be null");
            }
        }
        if (this.getKeyStore() != null) {
            KeyStore keystore;
            try {
                Security.addProvider(this.getProvider());
                keystore = KeyStore.getInstance(this.keyStoreType);
                is = IOUtils.getResourceAsStream((String)this.getKeyStore(), ((Object)((Object)this)).getClass());
                if (is == null) {
                    throw new FileNotFoundException("Failed to load keystore from classpath or local file: " + this.getKeyStore());
                }
                keystore.load(is, this.getKeyPassword().toCharArray());
            }
            catch (Exception e) {
                throw new InitialisationException(new Message(58, (Object)("KeyStore: " + this.getKeyStore())), (Throwable)e, (Object)this);
            }
            try {
                this.keyManagerFactory = KeyManagerFactory.getInstance(this.getKeyManagerAlgorithm());
                this.keyManagerFactory.init(keystore, this.getStorePassword().toCharArray());
            }
            catch (Exception e) {
                throw new InitialisationException(new Message(58, (Object)("Key Manager (" + this.getKeyManagerAlgorithm() + ")")), (Throwable)e, (Object)this);
            }
        }
        if (this.getTrustStore() != null) {
            KeyStore truststore;
            try {
                truststore = KeyStore.getInstance(this.trustStoreType);
                is = IOUtils.getResourceAsStream((String)this.getTrustStore(), ((Object)((Object)this)).getClass());
                if (is == null) {
                    throw new FileNotFoundException("Failed to load truststore from classpath or local file: " + this.getTrustStore());
                }
                truststore.load(is, this.getTrustStorePassword().toCharArray());
            }
            catch (Exception e) {
                throw new InitialisationException(new Message(58, (Object)("TrustStore: " + this.getTrustStore())), (Throwable)e, (Object)this);
            }
            try {
                this.trustManagerFactory = TrustManagerFactory.getInstance(this.getTrustManagerAlgorithm());
                this.trustManagerFactory.init(truststore);
            }
            catch (Exception e) {
                throw new InitialisationException(new Message(58, (Object)("Trust Manager (" + this.getTrustManagerAlgorithm() + ")")), (Throwable)e, (Object)this);
            }
        }
        super.doInitialise();
        if (this.protocolHandler != null) {
            System.setProperty("java.protocol.handler.pkgs", this.protocolHandler);
        }
        if (this.clientKeyStore != null) {
            try {
                String clientPath = FileUtils.getResourcePath((String)this.clientKeyStore, ((Object)((Object)this)).getClass());
                System.setProperty("javax.net.ssl.keyStore", clientPath);
                System.setProperty("javax.net.ssl.keyStorePassword", this.clientKeyStorePassword);
                this.logger.info((Object)("Set Client Key store: javax.net.ssl.keyStore=" + clientPath));
            }
            catch (IOException e) {
                throw new InitialisationException(new Message(58, (Object)("Client KeyStore: " + this.clientKeyStore)), (Throwable)e, (Object)this);
            }
        }
        if (this.trustStore != null) {
            System.setProperty("javax.net.ssl.trustStore", this.getTrustStore());
            System.setProperty("javax.net.ssl.trustStorePassword", this.getTrustStorePassword());
            this.logger.debug((Object)("Set Trust store: javax.net.ssl.trustStore=" + this.getTrustStore()));
        } else if (!this.isExplicitTrustStoreOnly()) {
            this.logger.info((Object)"Defaulting trust store to client Key Store");
            this.trustStore = this.getClientKeyStore();
            this.trustStorePassword = this.getClientKeyStorePassword();
            System.setProperty("javax.net.ssl.trustStore", this.getTrustStore());
            System.setProperty("javax.net.ssl.trustStorePassword", this.getTrustStorePassword());
            this.logger.debug((Object)("Set Trust store: javax.net.ssl.trustStore=" + this.getTrustStore()));
        }
    }

    public String getProtocol() {
        return "SSL";
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getStorePassword() {
        return this.storePassword;
    }

    public void setStorePassword(String storePassword) {
        this.storePassword = storePassword;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public TrustManagerFactory getTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    public void setTrustManagerFactory(TrustManagerFactory trustManagerFactory) {
        this.trustManagerFactory = trustManagerFactory;
    }

    public String getTrustManagerAlgorithm() {
        return this.trustManagerAlgorithm;
    }

    public void setTrustManagerAlgorithm(String trustManagerAlgorithm) {
        this.trustManagerAlgorithm = trustManagerAlgorithm;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyManagerAlgorithm() {
        return this.keyManagerAlgorithm;
    }

    public void setKeyManagerAlgorithm(String keyManagerAlgorithm) {
        this.keyManagerAlgorithm = keyManagerAlgorithm;
    }

    public boolean isRequireClientAuthentication() {
        return this.requireClientAuthentication;
    }

    public void setRequireClientAuthentication(boolean requireClientAuthentication) {
        this.requireClientAuthentication = requireClientAuthentication;
    }

    public KeyManagerFactory getKeyManagerFactory() {
        return this.keyManagerFactory;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public String getProtocolHandler() {
        return this.protocolHandler;
    }

    public void setProtocolHandler(String protocolHandler) {
        this.protocolHandler = protocolHandler;
    }

    public String getClientKeyStore() {
        return this.clientKeyStore;
    }

    public void setClientKeyStore(String clientKeyStore) throws IOException {
        this.clientKeyStore = clientKeyStore;
        if (this.clientKeyStore != null) {
            this.clientKeyStore = FileUtils.getResourcePath((String)clientKeyStore, ((Object)((Object)this)).getClass());
            this.logger.debug((Object)("Normalised clientKeyStore path to: " + this.getClientKeyStore()));
        }
    }

    public String getClientKeyStorePassword() {
        return this.clientKeyStorePassword;
    }

    public void setClientKeyStorePassword(String clientKeyStorePassword) {
        this.clientKeyStorePassword = clientKeyStorePassword;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) throws IOException {
        this.trustStore = trustStore;
        if (this.trustStore != null) {
            this.trustStore = FileUtils.getResourcePath((String)trustStore, ((Object)((Object)this)).getClass());
            this.logger.debug((Object)("Normalised trustStore path to: " + this.getTrustStore()));
        }
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public boolean isExplicitTrustStoreOnly() {
        return this.explicitTrustStoreOnly;
    }

    public void setExplicitTrustStoreOnly(boolean explicitTrustStoreOnly) {
        this.explicitTrustStoreOnly = explicitTrustStoreOnly;
    }
}

