/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.mule.providers.ssl.SslConnector;
import org.mule.providers.tcp.TcpMessageDispatcher;
import org.mule.umo.endpoint.UMOImmutableEndpoint;

public class SslMessageDispatcher
extends TcpMessageDispatcher {
    public SslMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
    }

    protected Socket createSocket(int port, InetAddress inetAddress) throws IOException {
        SSLContext context;
        SslConnector conn = (SslConnector)this.getConnector();
        try {
            context = SSLContext.getInstance(conn.getProtocol());
            context.init(conn.getKeyManagerFactory().getKeyManagers(), conn.getTrustManagerFactory().getTrustManagers(), null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage());
        }
        catch (KeyManagementException e) {
            throw new IOException(e.getMessage());
        }
        SSLSocketFactory factory = context.getSocketFactory();
        SSLSocket socket = (SSLSocket)factory.createSocket(inetAddress, port);
        return socket;
    }
}

