/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.commons.lang.StringUtils;
import org.mule.umo.security.tls.TlsConfiguration;

public class SslServerSocketFactory {
    private TlsConfiguration tls;

    SslServerSocketFactory(TlsConfiguration tls) {
        this.tls = tls;
    }

    protected ServerSocket createServerSocket(URI uri, int backlog) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        String host = StringUtils.defaultIfEmpty((String)uri.getHost(), (String)"localhost");
        InetAddress inetAddress = InetAddress.getByName(host);
        if (inetAddress.equals(InetAddress.getLocalHost()) || inetAddress.isLoopbackAddress() || host.trim().equals("localhost")) {
            return this.createServerSocket(uri.getPort(), backlog);
        }
        return this.createServerSocket(uri.getPort(), backlog, inetAddress);
    }

    protected ServerSocket createServerSocket(int port, int backlog, InetAddress address) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        SSLServerSocketFactory ssf = this.tls.getServerSocketFactory();
        return ssf.createServerSocket(port, backlog, address);
    }

    protected ServerSocket createServerSocket(int port, int backlog) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        SSLServerSocketFactory ssf = this.tls.getServerSocketFactory();
        return ssf.createServerSocket(port, backlog);
    }
}

