/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ssl;

import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.transport.ssl.SaveCertificateCallback;

public class SslCertificateTestCase
extends FunctionalTestCase {
    protected static String TEST_MESSAGE = "Test Request";
    private static int NUM_MESSAGES = 100;

    protected String getConfigResources() {
        return "ssl-certificate-test.xml";
    }

    public void testOnce() throws Exception {
        this.doTests(1);
    }

    public void testMany() throws Exception {
        this.doTests(NUM_MESSAGES);
    }

    protected void doTests(int n) throws Exception {
        FunctionalTestComponent ftc = (FunctionalTestComponent)this.getComponent("service");
        SslCertificateTestCase.assertNotNull((Object)ftc);
        SslCertificateTestCase.assertNotNull((Object)ftc.getEventCallback());
        SaveCertificateCallback callback = (SaveCertificateCallback)ftc.getEventCallback();
        callback.clear();
        MuleClient client = new MuleClient();
        for (int i = 0; i < n; ++i) {
            callback.clear();
            String msg = TEST_MESSAGE + n;
            MuleMessage result = client.send("in", (Object)msg, null);
            SslCertificateTestCase.assertTrue((boolean)callback.isCalled());
            SslCertificateTestCase.assertNotNull((String)"Null certificates", (Object)callback.getCertificates());
            SslCertificateTestCase.assertEquals((String)(msg + " Received"), (String)result.getPayloadAsString());
        }
    }
}

