/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ssl;

import java.util.Iterator;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.transport.ssl.SaveCertificatesCallback;

public class SslCertificatesTestCase
extends FunctionalTestCase {
    protected static String TEST_MESSAGE = "Test Request";
    private static int NUM_MESSAGES = 100;

    protected String getConfigResources() {
        return "ssl-certificates-test.xml";
    }

    public void testOnce() throws Exception {
        this.doTests(1);
    }

    public void testMany() throws Exception {
        this.doTests(NUM_MESSAGES);
    }

    protected void doTests(int n) throws Exception {
        FunctionalTestComponent ftc = (FunctionalTestComponent)this.getComponent("service");
        SslCertificatesTestCase.assertNotNull((Object)ftc);
        SslCertificatesTestCase.assertNotNull((Object)ftc.getEventCallback());
        SaveCertificatesCallback callback = (SaveCertificatesCallback)ftc.getEventCallback();
        callback.clear();
        MuleClient client = new MuleClient();
        for (int i = 0; i < n; ++i) {
            String msg = TEST_MESSAGE + n;
            MuleMessage result = client.send("in", (Object)msg, null);
            SslCertificatesTestCase.assertEquals((String)(msg + " Received"), (String)result.getPayloadAsString());
        }
        Iterator certificates = callback.getCertificates().iterator();
        for (int i = 0; i < n; ++i) {
            SslCertificatesTestCase.assertTrue((String)("No cert at " + i), (boolean)certificates.hasNext());
            SslCertificatesTestCase.assertNotNull((String)("Null cert at " + i), certificates.next());
        }
    }
}

