/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ssl;

import com.mockobjects.dynamic.Mock;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.HandshakeCompletedEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transport.ssl.MockHandshakeCompletedEvent;
import org.mule.transport.ssl.SslConnector;
import org.mule.transport.ssl.SslMessageReceiver;

public class SslHandshakeTimingTestCase
extends AbstractMuleTestCase {
    public void testSslHandshakeTimeout() throws Exception {
        SslMessageReceiver receiver = this.setupMockSslMessageReciever();
        try {
            DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
            this.callPreRoute(receiver, (MuleMessage)message);
            SslHandshakeTimingTestCase.fail();
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            SslHandshakeTimingTestCase.assertTrue((boolean)(cause instanceof IllegalStateException));
        }
    }

    public void testSslHandshakeSuccessful() throws Exception {
        SslMessageReceiver receiver = this.setupMockSslMessageReciever();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        receiver.handshakeCompleted((HandshakeCompletedEvent)new MockHandshakeCompletedEvent());
        this.callPreRoute(receiver, (MuleMessage)message);
        SslHandshakeTimingTestCase.assertNotNull((Object)message.getProperty("PEER_CERTIFICATES"));
        SslHandshakeTimingTestCase.assertNotNull((Object)message.getProperty("LOCAL_CERTIFICATES"));
    }

    private SslMessageReceiver setupMockSslMessageReciever() throws Exception {
        SslConnector connector = new SslConnector();
        connector.setSslHandshakeTimeout(1000L);
        Mock mockService = new Mock(Service.class);
        mockService.expectAndReturn("getResponseRouter", null);
        mockService.expectAndReturn("getResponseRouter", null);
        Service service = (Service)mockService.proxy();
        Map properties = Collections.emptyMap();
        Mock mockEndpoint = new Mock(InboundEndpoint.class);
        mockEndpoint.expectAndReturn("getConnector", (Object)connector);
        mockEndpoint.expectAndReturn("getEncoding", (Object)new DefaultMuleConfiguration().getDefaultEncoding());
        mockEndpoint.expectAndReturn("getProperties", properties);
        mockEndpoint.expectAndReturn("getProperties", properties);
        InboundEndpoint endpoint = (InboundEndpoint)mockEndpoint.proxy();
        return new SslMessageReceiver((Connector)connector, service, endpoint);
    }

    private void callPreRoute(SslMessageReceiver receiver, MuleMessage message) throws Exception {
        Method preRouteMessage = receiver.getClass().getDeclaredMethod("preRoute", DefaultMuleMessage.class);
        SslHandshakeTimingTestCase.assertNotNull((Object)preRouteMessage);
        preRouteMessage.setAccessible(true);
        preRouteMessage.invoke((Object)receiver, message);
    }
}

