/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ssl;

import org.mule.tck.FunctionalTestCase;
import org.mule.transport.ssl.SslConnector;

public class SslNamespaceHandlerTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "ssl-namespace-config.xml";
    }

    public void testConnectorProperties() throws Exception {
        SslConnector connector = (SslConnector)muleContext.getRegistry().lookupConnector("sslConnector");
        SslNamespaceHandlerTestCase.assertNotNull((Object)connector);
        SslNamespaceHandlerTestCase.assertEquals((int)1024, (int)connector.getSendBufferSize());
        SslNamespaceHandlerTestCase.assertEquals((int)2048, (int)connector.getReceiveBufferSize());
        SslNamespaceHandlerTestCase.assertTrue((boolean)connector.isKeepAlive());
        SslNamespaceHandlerTestCase.assertTrue((boolean)connector.getKeyStore().endsWith("/serverKeystore"));
        SslNamespaceHandlerTestCase.assertEquals((String)"mulepassword", (String)connector.getKeyPassword());
        SslNamespaceHandlerTestCase.assertEquals((String)"mulepassword", (String)connector.getKeyStorePassword());
        SslNamespaceHandlerTestCase.assertTrue((boolean)connector.getClientKeyStore().endsWith("/clientKeystore"));
        SslNamespaceHandlerTestCase.assertEquals((String)"mulepassword", (String)connector.getClientKeyStorePassword());
        SslNamespaceHandlerTestCase.assertTrue((boolean)connector.getTrustStore().endsWith("/trustStore"));
        SslNamespaceHandlerTestCase.assertEquals((String)"mulepassword", (String)connector.getTrustStorePassword());
        SslNamespaceHandlerTestCase.assertTrue((boolean)connector.isExplicitTrustStoreOnly());
        SslNamespaceHandlerTestCase.assertTrue((boolean)connector.isRequireClientAuthentication());
        SslNamespaceHandlerTestCase.assertEquals((String)"foo", (String)connector.getProtocolHandler());
    }
}

