/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ssl;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.IOException;
import java.net.Socket;
import java.security.cert.Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.resource.spi.work.Work;
import org.mule.DefaultMuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.ssl.SslConnector;
import org.mule.transport.tcp.TcpMessageReceiver;

public class SslMessageReceiver
extends TcpMessageReceiver
implements HandshakeCompletedListener {
    private CountDownLatch handshakeComplete = new CountDownLatch(1);
    private Certificate[] peerCertificateChain;
    private Certificate[] localCertificateChain;

    public SslMessageReceiver(Connector connector, Service service, InboundEndpoint endpoint) throws CreateException {
        super(connector, service, endpoint);
    }

    protected Work createWork(Socket socket) throws IOException {
        return new SslWorker(socket, (AbstractMessageReceiver)this);
    }

    private void preRoute(DefaultMuleMessage message) throws Exception {
        long sslHandshakeTimeout = ((SslConnector)this.getConnector()).getSslHandshakeTimeout();
        boolean rc = this.handshakeComplete.await(sslHandshakeTimeout, TimeUnit.MILLISECONDS);
        if (!rc) {
            throw new IllegalStateException("Handshake did not complete");
        }
        if (this.peerCertificateChain != null) {
            message.setProperty("PEER_CERTIFICATES", (Object)this.peerCertificateChain);
        }
        if (this.localCertificateChain != null) {
            message.setProperty("LOCAL_CERTIFICATES", (Object)this.localCertificateChain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handshakeCompleted(HandshakeCompletedEvent event) {
        try {
            this.localCertificateChain = event.getLocalCertificates();
            try {
                this.peerCertificateChain = event.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                this.logger.debug((Object)("Cannot get peer certificate chain: " + e.getMessage()));
            }
        }
        finally {
            this.handshakeComplete.countDown();
        }
    }

    protected class SslWorker
    extends TcpMessageReceiver.TcpWorker {
        public SslWorker(Socket socket, AbstractMessageReceiver receiver) throws IOException {
            super((TcpMessageReceiver)SslMessageReceiver.this, socket, receiver);
            ((SSLSocket)socket).addHandshakeCompletedListener(SslMessageReceiver.this);
        }

        protected void preRouteMuleMessage(DefaultMuleMessage message) throws Exception {
            super.preRouteMuleMessage(message);
            SslMessageReceiver.this.preRoute(message);
        }

        protected void shutdownSocket() throws IOException {
        }
    }
}

