/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ssl;

import org.mule.endpoint.MuleEndpointURI;
import org.mule.tck.AbstractMuleTestCase;

public class SslEndpointTestCase
extends AbstractMuleTestCase {
    public void testHostPortUrl() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("ssl://localhost:7856", muleContext);
        url.initialise();
        SslEndpointTestCase.assertEquals((String)"ssl", (String)url.getScheme());
        SslEndpointTestCase.assertEquals((String)"ssl://localhost:7856", (String)url.getAddress());
        SslEndpointTestCase.assertNull((Object)url.getEndpointName());
        SslEndpointTestCase.assertEquals((int)7856, (int)url.getPort());
        SslEndpointTestCase.assertEquals((String)"localhost", (String)url.getHost());
        SslEndpointTestCase.assertEquals((String)"ssl://localhost:7856", (String)url.getAddress());
        SslEndpointTestCase.assertEquals((int)0, (int)url.getParams().size());
    }

    public void testQueryParams1() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("ssl://localhost:7856?param=1", muleContext);
        url.initialise();
        SslEndpointTestCase.assertEquals((String)"ssl", (String)url.getScheme());
        SslEndpointTestCase.assertEquals((String)"ssl://localhost:7856", (String)url.getAddress());
        SslEndpointTestCase.assertNull((Object)url.getEndpointName());
        SslEndpointTestCase.assertEquals((int)7856, (int)url.getPort());
        SslEndpointTestCase.assertEquals((String)"localhost", (String)url.getHost());
        SslEndpointTestCase.assertEquals((String)"ssl://localhost:7856?param=1", (String)url.toString());
        SslEndpointTestCase.assertEquals((int)1, (int)url.getParams().size());
        SslEndpointTestCase.assertEquals((String)"1", (String)url.getParams().getProperty("param"));
    }

    public void testQueryParams2() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("ssl://localhost:7856?param=1&endpointName=sslProvider&blankParam=", muleContext);
        url.initialise();
        SslEndpointTestCase.assertEquals((String)"ssl", (String)url.getScheme());
        SslEndpointTestCase.assertEquals((String)"ssl://localhost:7856", (String)url.getAddress());
        SslEndpointTestCase.assertNotNull((Object)url.getEndpointName());
        SslEndpointTestCase.assertEquals((String)"sslProvider", (String)url.getEndpointName());
        SslEndpointTestCase.assertEquals((int)7856, (int)url.getPort());
        SslEndpointTestCase.assertEquals((String)"localhost", (String)url.getHost());
        SslEndpointTestCase.assertEquals((String)"ssl://localhost:7856?param=1&endpointName=sslProvider&blankParam=", (String)url.toString());
        SslEndpointTestCase.assertEquals((String)"param=1&endpointName=sslProvider&blankParam=", (String)url.getQuery());
        SslEndpointTestCase.assertEquals((int)3, (int)url.getParams().size());
        SslEndpointTestCase.assertEquals((String)"1", (String)url.getParams().getProperty("param"));
        SslEndpointTestCase.assertEquals((String)"", (String)url.getParams().getProperty("blankParam"));
    }
}

