/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ssl;

import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.service.Service;
import org.mule.module.client.MuleClient;
import org.mule.tck.DynamicPortTestCase;
import org.mule.tck.functional.CounterCallback;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.testmodels.mule.TestSedaService;

public class SslFunctionalTestCase
extends DynamicPortTestCase {
    private static int NUM_MESSAGES = 100;

    protected String getConfigResources() {
        return "ssl-functional-test.xml";
    }

    public void testSend() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("sendEndpoint", (Object)"Test Message", null);
        SslFunctionalTestCase.assertEquals((String)"Test Message Received", (String)result.getPayloadAsString());
    }

    public void testSendMany() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        for (int i = 0; i < NUM_MESSAGES; ++i) {
            MuleMessage result = client.send("sendManyEndpoint", (Object)"Test Message", null);
            SslFunctionalTestCase.assertEquals((String)"Test Message Received", (String)result.getPayloadAsString());
        }
        Service c = muleContext.getRegistry().lookupService("testComponent2");
        SslFunctionalTestCase.assertTrue((String)"Service should be a TestSedaService", (boolean)(c instanceof TestSedaService));
        Object ftc = this.getComponent((FlowConstruct)c);
        SslFunctionalTestCase.assertNotNull((String)"Functional Test Service not found in the model.", (Object)ftc);
        SslFunctionalTestCase.assertTrue((String)"Service should be a FunctionalTestComponent", (boolean)(ftc instanceof FunctionalTestComponent));
        EventCallback cc = ((FunctionalTestComponent)ftc).getEventCallback();
        SslFunctionalTestCase.assertNotNull((String)"EventCallback is null", (Object)cc);
        SslFunctionalTestCase.assertTrue((String)"EventCallback should be a CounterCallback", (boolean)(cc instanceof CounterCallback));
        SslFunctionalTestCase.assertEquals((int)NUM_MESSAGES, (int)((CounterCallback)cc).getCallbackCount());
    }

    public void testAsynchronous() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        client.dispatch("asyncEndpoint", (Object)"Test Message", null);
        Thread.sleep(100L);
        MuleMessage response = client.request("asyncEndpoint", 5000L);
        SslFunctionalTestCase.assertNotNull((String)"Response is null", (Object)response);
        SslFunctionalTestCase.assertEquals((String)"Test Message Received Async", (String)response.getPayloadAsString());
    }

    protected int getNumPortsToFind() {
        return 3;
    }
}

