/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ssl;

import org.mule.tck.FunctionalTestCase;
import org.mule.transport.ssl.SslConnector;

public class TlsNamespaceHandlerTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "tls-namespace-config.xml";
    }

    public void testConnectorProperties() throws Exception {
        SslConnector connector = (SslConnector)muleContext.getRegistry().lookupConnector("sslConnector");
        TlsNamespaceHandlerTestCase.assertNotNull((Object)connector);
        TlsNamespaceHandlerTestCase.assertEquals((int)1024, (int)connector.getSendBufferSize());
        TlsNamespaceHandlerTestCase.assertEquals((int)2048, (int)connector.getReceiveBufferSize());
        TlsNamespaceHandlerTestCase.assertTrue((boolean)connector.isKeepAlive());
        TlsNamespaceHandlerTestCase.assertTrue((boolean)connector.getKeyStore().endsWith("/serverKeystore"));
        TlsNamespaceHandlerTestCase.assertEquals((String)"mulepassword", (String)connector.getKeyPassword());
        TlsNamespaceHandlerTestCase.assertEquals((String)"mulepassword", (String)connector.getKeyStorePassword());
        TlsNamespaceHandlerTestCase.assertTrue((boolean)connector.getClientKeyStore().endsWith("/clientKeystore"));
        TlsNamespaceHandlerTestCase.assertEquals((String)"mulepassword", (String)connector.getClientKeyStorePassword());
        TlsNamespaceHandlerTestCase.assertTrue((boolean)connector.getTrustStore().endsWith("/trustStore"));
        TlsNamespaceHandlerTestCase.assertEquals((String)"mulepassword", (String)connector.getTrustStorePassword());
        TlsNamespaceHandlerTestCase.assertTrue((boolean)connector.isExplicitTrustStoreOnly());
        TlsNamespaceHandlerTestCase.assertTrue((boolean)connector.isRequireClientAuthentication());
    }
}

