/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ssl;

import java.security.cert.Certificate;
import java.util.Iterator;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.DynamicPortTestCase;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.transport.ssl.SaveCertificatesCallback;

public class SslCertificatesTestCase
extends DynamicPortTestCase {
    private static int NUM_MESSAGES = 100;

    protected String getConfigResources() {
        return "ssl-certificates-test.xml";
    }

    protected int getNumPortsToFind() {
        return 1;
    }

    public void testOnce() throws Exception {
        this.doTests(1);
    }

    public void testMany() throws Exception {
        this.doTests(NUM_MESSAGES);
    }

    protected void doTests(int numberOfMessages) throws Exception {
        SaveCertificatesCallback callback = this.setupEventCallback();
        MuleClient client = new MuleClient(muleContext);
        for (int i = 0; i < numberOfMessages; ++i) {
            String msg = "Test Message" + i;
            MuleMessage result = client.send("in", (Object)msg, null);
            SslCertificatesTestCase.assertEquals((String)(msg + " Received"), (String)result.getPayloadAsString());
        }
        Iterator<Certificate[]> certificates = callback.getCertificates().iterator();
        for (int i = 0; i < numberOfMessages; ++i) {
            SslCertificatesTestCase.assertTrue((String)("No cert at " + i), (boolean)certificates.hasNext());
            SslCertificatesTestCase.assertNotNull((String)("Null cert at " + i), (Object)certificates.next());
        }
    }

    private SaveCertificatesCallback setupEventCallback() throws Exception {
        FunctionalTestComponent ftc = (FunctionalTestComponent)this.getComponent("service");
        SslCertificatesTestCase.assertNotNull((Object)ftc);
        SslCertificatesTestCase.assertNotNull((Object)ftc.getEventCallback());
        SaveCertificatesCallback callback = (SaveCertificatesCallback)ftc.getEventCallback();
        callback.clear();
        return callback;
    }
}

