/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ssl;

import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.transport.AbstractConnectorTestCase;
import org.mule.transport.ssl.SslConnector;

public class SslConnectorTestCase
extends AbstractConnectorTestCase {
    public Connector createConnector() throws Exception {
        SslConnector cnn = new SslConnector(muleContext);
        cnn.setName("SslConnector");
        cnn.setKeyStore("serverKeystore");
        cnn.setClientKeyStore("clientKeystore");
        cnn.setClientKeyStorePassword("mulepassword");
        cnn.setKeyPassword("mulepassword");
        cnn.setKeyStorePassword("mulepassword");
        cnn.setTrustStore("trustStore");
        cnn.setTrustStorePassword("mulepassword");
        cnn.getDispatcherThreadingProfile().setDoThreading(false);
        return cnn;
    }

    public void testClientConnector() throws Exception {
        SslConnector cnn = new SslConnector(muleContext);
        cnn.setClientKeyStore("clientKeystore");
        cnn.setClientKeyStorePassword("mulepassword");
        cnn.getDispatcherThreadingProfile().setDoThreading(false);
    }

    public String getTestEndpointURI() {
        return "ssl://localhost:56801";
    }

    public Object getValidMessage() throws Exception {
        return "Hello".getBytes();
    }

    public void testValidListener() throws Exception {
        Service service = SslConnectorTestCase.getTestService((String)"orange", Orange.class);
        Connector connector = this.getConnector();
        InboundEndpoint endpoint2 = muleContext.getEndpointFactory().getInboundEndpoint("ssl://localhost:30303");
        connector.registerListener(endpoint2, (MessageProcessor)this.getSensingNullMessageProcessor(), (FlowConstruct)service);
        try {
            connector.registerListener(endpoint2, (MessageProcessor)this.getSensingNullMessageProcessor(), (FlowConstruct)service);
            SslConnectorTestCase.fail((String)"cannot register on the same endpointUri");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testProperties() throws Exception {
        SslConnector c = (SslConnector)this.getConnector();
        c.setSendBufferSize(1024);
        SslConnectorTestCase.assertEquals((int)1024, (int)c.getSendBufferSize());
        c.setSendBufferSize(0);
        SslConnectorTestCase.assertEquals((int)-1, (int)c.getSendBufferSize());
    }
}

