/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ssl;

import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transport.ssl.SslConnector;

public class SslNamespaceHandlerTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "ssl-namespace-config.xml";
    }

    @Test
    public void checkConnectorProperties() throws Exception {
        SslConnector connector = (SslConnector)muleContext.getRegistry().lookupConnector("sslConnector");
        Assert.assertNotNull((Object)connector);
        Assert.assertEquals((long)1024L, (long)connector.getSendBufferSize());
        Assert.assertEquals((long)2048L, (long)connector.getReceiveBufferSize());
        Assert.assertTrue((boolean)connector.isKeepAlive());
        Assert.assertTrue((boolean)connector.getKeyStore().endsWith("/serverKeystore"));
        Assert.assertEquals((Object)"muleserver", (Object)connector.getKeyAlias());
        Assert.assertEquals((Object)"mulepassword", (Object)connector.getKeyPassword());
        Assert.assertEquals((Object)"mulepassword", (Object)connector.getKeyStorePassword());
        Assert.assertTrue((boolean)connector.getClientKeyStore().endsWith("/clientKeystore"));
        Assert.assertEquals((Object)"mulepassword", (Object)connector.getClientKeyStorePassword());
        Assert.assertTrue((boolean)connector.getTrustStore().endsWith("/trustStore"));
        Assert.assertEquals((Object)"mulepassword", (Object)connector.getTrustStorePassword());
        Assert.assertTrue((boolean)connector.isExplicitTrustStoreOnly());
        Assert.assertTrue((boolean)connector.isRequireClientAuthentication());
        Assert.assertEquals((Object)"foo", (Object)connector.getProtocolHandler());
    }
}

