/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ssl;

import org.junit.Assert;
import org.junit.Test;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class SslEndpointTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testHostPortUrl() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("ssl://localhost:7856", muleContext);
        url.initialise();
        Assert.assertEquals((Object)"ssl", (Object)url.getScheme());
        Assert.assertEquals((Object)"ssl://localhost:7856", (Object)url.getAddress());
        Assert.assertNull((Object)url.getEndpointName());
        Assert.assertEquals((long)7856L, (long)url.getPort());
        Assert.assertEquals((Object)"localhost", (Object)url.getHost());
        Assert.assertEquals((Object)"ssl://localhost:7856", (Object)url.getAddress());
        Assert.assertEquals((long)0L, (long)url.getParams().size());
    }

    @Test
    public void testQueryParams1() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("ssl://localhost:7856?param=1", muleContext);
        url.initialise();
        Assert.assertEquals((Object)"ssl", (Object)url.getScheme());
        Assert.assertEquals((Object)"ssl://localhost:7856", (Object)url.getAddress());
        Assert.assertNull((Object)url.getEndpointName());
        Assert.assertEquals((long)7856L, (long)url.getPort());
        Assert.assertEquals((Object)"localhost", (Object)url.getHost());
        Assert.assertEquals((Object)"ssl://localhost:7856?param=1", (Object)url.toString());
        Assert.assertEquals((long)1L, (long)url.getParams().size());
        Assert.assertEquals((Object)"1", (Object)url.getParams().getProperty("param"));
    }

    @Test
    public void testQueryParams2() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("ssl://localhost:7856?param=1&endpointName=sslProvider&blankParam=", muleContext);
        url.initialise();
        Assert.assertEquals((Object)"ssl", (Object)url.getScheme());
        Assert.assertEquals((Object)"ssl://localhost:7856", (Object)url.getAddress());
        Assert.assertNotNull((Object)url.getEndpointName());
        Assert.assertEquals((Object)"sslProvider", (Object)url.getEndpointName());
        Assert.assertEquals((long)7856L, (long)url.getPort());
        Assert.assertEquals((Object)"localhost", (Object)url.getHost());
        Assert.assertEquals((Object)"ssl://localhost:7856?param=1&endpointName=sslProvider&blankParam=", (Object)url.toString());
        Assert.assertEquals((Object)"param=1&endpointName=sslProvider&blankParam=", (Object)url.getQuery());
        Assert.assertEquals((long)3L, (long)url.getParams().size());
        Assert.assertEquals((Object)"1", (Object)url.getParams().getProperty("param"));
        Assert.assertEquals((Object)"", (Object)url.getParams().getProperty("blankParam"));
    }
}

