/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ssl;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.service.Service;
import org.mule.module.client.MuleClient;
import org.mule.tck.functional.CounterCallback;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.testmodels.mule.TestSedaService;

public class SslFunctionalTestCase
extends FunctionalTestCase {
    private static int NUM_MESSAGES = 100;
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");
    @Rule
    public DynamicPort dynamicPort3 = new DynamicPort("port3");

    protected String getConfigResources() {
        return "ssl-functional-test.xml";
    }

    protected boolean isExcluded() {
        return super.isExcluded() || System.getProperty("java.version").matches("1\\.7\\..*");
    }

    @Test
    public void testSend() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("sendEndpoint", (Object)"Test Message", null);
        Assert.assertEquals((Object)"Test Message Received", (Object)result.getPayloadAsString());
    }

    @Test
    public void testSendMany() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        for (int i = 0; i < NUM_MESSAGES; ++i) {
            MuleMessage result = client.send("sendManyEndpoint", (Object)"Test Message", null);
            Assert.assertEquals((Object)"Test Message Received", (Object)result.getPayloadAsString());
        }
        Service c = muleContext.getRegistry().lookupService("testComponent2");
        Assert.assertTrue((String)"Service should be a TestSedaService", (boolean)(c instanceof TestSedaService));
        Object ftc = this.getComponent((FlowConstruct)c);
        Assert.assertNotNull((String)"Functional Test Service not found in the model.", (Object)ftc);
        Assert.assertTrue((String)"Service should be a FunctionalTestComponent", (boolean)(ftc instanceof FunctionalTestComponent));
        EventCallback cc = ((FunctionalTestComponent)ftc).getEventCallback();
        Assert.assertNotNull((String)"EventCallback is null", (Object)cc);
        Assert.assertTrue((String)"EventCallback should be a CounterCallback", (boolean)(cc instanceof CounterCallback));
        Assert.assertEquals((long)NUM_MESSAGES, (long)((CounterCallback)cc).getCallbackCount());
    }

    @Test
    public void testAsynchronous() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        client.dispatch("asyncEndpoint", (Object)"Test Message", null);
        Thread.sleep(100L);
        MuleMessage response = client.request("asyncEndpoint", 5000L);
        Assert.assertNotNull((String)"Response is null", (Object)response);
        Assert.assertEquals((Object)"Test Message Received Async", (Object)response.getPayloadAsString());
    }
}

