/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ssl;

import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.ssl.SaveCertificatesCallback;

public class SslCertificatesTestCase
extends AbstractServiceAndFlowTestCase {
    private static int NUM_MESSAGES = 100;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public SslCertificatesTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "ssl-certificates-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "ssl-certificates-test-flow.xml"});
    }

    @Test
    public void testOnce() throws Exception {
        this.doTests(1);
    }

    @Test
    public void testMany() throws Exception {
        this.doTests(NUM_MESSAGES);
    }

    protected void doTests(int numberOfMessages) throws Exception {
        SaveCertificatesCallback callback = this.setupEventCallback();
        MuleClient client = new MuleClient(muleContext);
        for (int i = 0; i < numberOfMessages; ++i) {
            String msg = "Test Message" + i;
            MuleMessage result = client.send("in", (Object)msg, null);
            Assert.assertEquals((Object)(msg + " Received"), (Object)result.getPayloadAsString());
        }
        Iterator<Certificate[]> certificates = callback.getCertificates().iterator();
        for (int i = 0; i < numberOfMessages; ++i) {
            Assert.assertTrue((String)("No cert at " + i), (boolean)certificates.hasNext());
            Assert.assertNotNull((String)("Null cert at " + i), (Object)certificates.next());
        }
    }

    private SaveCertificatesCallback setupEventCallback() throws Exception {
        FunctionalTestComponent ftc = (FunctionalTestComponent)this.getComponent("service");
        Assert.assertNotNull((Object)ftc);
        Assert.assertNotNull((Object)ftc.getEventCallback());
        SaveCertificatesCallback callback = (SaveCertificatesCallback)ftc.getEventCallback();
        callback.clear();
        return callback;
    }
}

