/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ssl;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transport.ssl.DefaultTlsContextFactory;
import org.mule.transport.ssl.SslConnector;
import org.mule.transport.ssl.api.TlsContextFactory;
import org.mule.transport.ssl.api.TlsContextKeyStoreConfiguration;
import org.mule.transport.ssl.api.TlsContextTrustStoreConfiguration;

public class TlsNamespaceHandlerTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "tls-namespace-config.xml";
    }

    @Test
    public void testConnectorProperties() throws Exception {
        SslConnector connector = (SslConnector)muleContext.getRegistry().lookupConnector("sslConnector");
        Assert.assertNotNull((Object)connector);
        Assert.assertEquals((long)1024L, (long)connector.getSendBufferSize());
        Assert.assertEquals((long)2048L, (long)connector.getReceiveBufferSize());
        Assert.assertTrue((boolean)connector.isKeepAlive());
        Assert.assertTrue((boolean)connector.getKeyStore().endsWith("/serverKeystore"));
        Assert.assertEquals((Object)"muleserver", (Object)connector.getKeyAlias());
        Assert.assertEquals((Object)"mulepassword", (Object)connector.getKeyPassword());
        Assert.assertEquals((Object)"mulepassword", (Object)connector.getKeyStorePassword());
        Assert.assertTrue((boolean)connector.getClientKeyStore().endsWith("/clientKeystore"));
        Assert.assertEquals((Object)"mulepassword", (Object)connector.getClientKeyStorePassword());
        Assert.assertTrue((boolean)connector.getTrustStore().endsWith("/trustStore"));
        Assert.assertEquals((Object)"mulepassword", (Object)connector.getTrustStorePassword());
        Assert.assertTrue((boolean)connector.isExplicitTrustStoreOnly());
        Assert.assertTrue((boolean)connector.isRequireClientAuthentication());
    }

    @Test
    public void testTlsContextProperties() throws Exception {
        DefaultTlsContextFactory tlsContextFactory = (DefaultTlsContextFactory)muleContext.getRegistry().get("tlsContext");
        Assert.assertThat((Object)tlsContextFactory.getTrustStorePath(), (Matcher)CoreMatchers.endsWith((String)"trustStore"));
        Assert.assertThat((Object)tlsContextFactory.getTrustStorePassword(), (Matcher)CoreMatchers.equalTo((Object)"testTrustStorePassword"));
        Assert.assertThat((Object)tlsContextFactory.getTrustStoreType(), (Matcher)CoreMatchers.equalTo((Object)"testTrustStoreType"));
        Assert.assertThat((Object)tlsContextFactory.getTrustManagerAlgorithm(), (Matcher)CoreMatchers.equalTo((Object)"testTrustStoreAlgorithm"));
        Assert.assertThat((Object)tlsContextFactory.getKeyStorePath(), (Matcher)CoreMatchers.endsWith((String)"serverKeystore"));
        Assert.assertThat((Object)tlsContextFactory.getKeyStorePassword(), (Matcher)CoreMatchers.equalTo((Object)"testKeyStorePassword"));
        Assert.assertThat((Object)tlsContextFactory.getKeyStoreType(), (Matcher)CoreMatchers.equalTo((Object)"testKeyStoreType"));
        Assert.assertThat((Object)tlsContextFactory.getKeyManagerPassword(), (Matcher)CoreMatchers.equalTo((Object)"testKeyPassword"));
        Assert.assertThat((Object)tlsContextFactory.getKeyManagerAlgorithm(), (Matcher)CoreMatchers.equalTo((Object)"testKeyStoreAlgorithm"));
        Assert.assertThat((Object)tlsContextFactory.getKeyAlias(), (Matcher)CoreMatchers.equalTo((Object)"testKeyStoreAlias"));
    }

    @Test
    public void testTlsContextKeyStoreProperties() throws Exception {
        TlsContextFactory tlsContextFactory = (TlsContextFactory)muleContext.getRegistry().get("tlsContext");
        TlsContextKeyStoreConfiguration keyStoreConfig = tlsContextFactory.getKeyStoreConfiguration();
        Assert.assertThat((Object)keyStoreConfig.getPath(), (Matcher)CoreMatchers.endsWith((String)"serverKeystore"));
        Assert.assertThat((Object)keyStoreConfig.getPassword(), (Matcher)CoreMatchers.equalTo((Object)"testKeyStorePassword"));
        Assert.assertThat((Object)keyStoreConfig.getType(), (Matcher)CoreMatchers.equalTo((Object)"testKeyStoreType"));
        Assert.assertThat((Object)keyStoreConfig.getKeyPassword(), (Matcher)CoreMatchers.equalTo((Object)"testKeyPassword"));
        Assert.assertThat((Object)keyStoreConfig.getAlgorithm(), (Matcher)CoreMatchers.equalTo((Object)"testKeyStoreAlgorithm"));
        Assert.assertThat((Object)keyStoreConfig.getAlias(), (Matcher)CoreMatchers.equalTo((Object)"testKeyStoreAlias"));
    }

    @Test
    public void testTlsContextTrustStoreProperties() throws Exception {
        TlsContextFactory tlsContextFactory = (TlsContextFactory)muleContext.getRegistry().get("tlsContext");
        TlsContextTrustStoreConfiguration trustStoreConfig = tlsContextFactory.getTrustStoreConfiguration();
        Assert.assertThat((Object)trustStoreConfig.getPath(), (Matcher)CoreMatchers.endsWith((String)"trustStore"));
        Assert.assertThat((Object)trustStoreConfig.getPassword(), (Matcher)CoreMatchers.equalTo((Object)"testTrustStorePassword"));
        Assert.assertThat((Object)trustStoreConfig.getType(), (Matcher)CoreMatchers.equalTo((Object)"testTrustStoreType"));
        Assert.assertThat((Object)trustStoreConfig.getAlgorithm(), (Matcher)CoreMatchers.equalTo((Object)"testTrustStoreAlgorithm"));
    }
}

