/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ssl;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.transport.ssl.DefaultTlsContextFactory;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;

public class DefaultTlsContextFactoryTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @BeforeClass
    public static void createTlsPropertiesFile() throws Exception {
        PrintWriter writer = new PrintWriter(DefaultTlsContextFactoryTestCase.getTlsPropertiesFile(), "UTF-8");
        writer.println("enabledCipherSuites=" + DefaultTlsContextFactoryTestCase.getFileEnabledCipherSuites());
        writer.println("enabledProtocols=" + DefaultTlsContextFactoryTestCase.getFileEnabledProtocols());
        writer.close();
    }

    @AfterClass
    public static void removeTlsPropertiesFile() {
        DefaultTlsContextFactoryTestCase.getTlsPropertiesFile().delete();
    }

    private static File getTlsPropertiesFile() {
        String path = ClassUtils.getClassPathRoot(DefaultTlsContextFactoryTestCase.class).getPath();
        return new File(path, String.format("tls-%s.conf", "default"));
    }

    public static String getFileEnabledProtocols() {
        return "TLSv1.1, TLSv1.2";
    }

    public static String getFileEnabledCipherSuites() {
        return "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256, TLS_DHE_DSS_WITH_AES_128_CBC_SHA";
    }

    @Test
    public void failIfTrustStoreIsNonexistent() throws Exception {
        DefaultTlsContextFactory tlsContextFactory = new DefaultTlsContextFactory();
        this.expectedException.expect(IOException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Resource non-existent-trust-store could not be found"));
        tlsContextFactory.setTrustStorePath("non-existent-trust-store");
    }

    @Test
    public void useConfigFileIfDefaultProtocolsAndCipherSuites() throws Exception {
        DefaultTlsContextFactory tlsContextFactory = new DefaultTlsContextFactory();
        tlsContextFactory.setEnabledCipherSuites("DEFAULT");
        tlsContextFactory.setEnabledProtocols("default");
        tlsContextFactory.initialise();
        Assert.assertThat((Object)tlsContextFactory.getEnabledCipherSuites(), (Matcher)Matchers.is((Object)StringUtils.splitAndTrim((String)DefaultTlsContextFactoryTestCase.getFileEnabledCipherSuites(), (String)",")));
        Assert.assertThat((Object)tlsContextFactory.getEnabledProtocols(), (Matcher)Matchers.is((Object)StringUtils.splitAndTrim((String)DefaultTlsContextFactoryTestCase.getFileEnabledProtocols(), (String)",")));
    }

    @Test
    public void overrideConfigFile() throws Exception {
        DefaultTlsContextFactory tlsContextFactory = new DefaultTlsContextFactory();
        tlsContextFactory.setEnabledCipherSuites("TLS_DHE_DSS_WITH_AES_128_CBC_SHA");
        tlsContextFactory.setEnabledProtocols("TLSv1.1");
        tlsContextFactory.initialise();
        String[] enabledCipherSuites = tlsContextFactory.getEnabledCipherSuites();
        Assert.assertThat((Object)enabledCipherSuites.length, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)enabledCipherSuites, (Matcher)Matchers.is((Matcher)Matchers.arrayContaining((Object[])new String[]{"TLS_DHE_DSS_WITH_AES_128_CBC_SHA"})));
        String[] enabledProtocols = tlsContextFactory.getEnabledProtocols();
        Assert.assertThat((Object)enabledProtocols.length, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)enabledProtocols, (Matcher)Matchers.is((Matcher)Matchers.arrayContaining((Object[])new String[]{"TLSv1.1"})));
    }

    @Test
    public void failIfProtocolsDoNotMatchConfigFile() throws Exception {
        DefaultTlsContextFactory tlsContextFactory = new DefaultTlsContextFactory();
        tlsContextFactory.setEnabledProtocols("TLSv1,SSLv3");
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"protocols are invalid"));
        tlsContextFactory.initialise();
    }

    @Test
    public void failIfCipherSuitesDoNotMatchConfigFile() throws Exception {
        DefaultTlsContextFactory tlsContextFactory = new DefaultTlsContextFactory();
        tlsContextFactory.setEnabledCipherSuites("SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA");
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"cipher suites are invalid"));
        tlsContextFactory.initialise();
    }
}

