/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ssl;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transport.ssl.DefaultTlsContextFactory;
import org.mule.transport.ssl.SslConnector;
import org.mule.transport.ssl.api.TlsContextFactory;
import org.mule.transport.ssl.api.TlsContextKeyStoreConfiguration;
import org.mule.transport.ssl.api.TlsContextTrustStoreConfiguration;

public class TlsNamespaceHandlerTestCase
extends FunctionalTestCase {
    private static final String PASSWORD = "mulepassword";
    private static final String ALIAS = "muleserver";
    private static final String TYPE = "jks";
    private static final String ALGORITHM = "SunX509";

    protected String getConfigFile() {
        return "tls-namespace-config.xml";
    }

    @Test
    public void testConnectorProperties() throws Exception {
        SslConnector connector = (SslConnector)muleContext.getRegistry().lookupConnector("sslConnector");
        Assert.assertNotNull((Object)connector);
        Assert.assertEquals((long)1024L, (long)connector.getSendBufferSize());
        Assert.assertEquals((long)2048L, (long)connector.getReceiveBufferSize());
        Assert.assertTrue((boolean)connector.isKeepAlive());
        Assert.assertTrue((boolean)connector.getKeyStore().endsWith("/serverKeystore"));
        Assert.assertEquals((Object)ALIAS, (Object)connector.getKeyAlias());
        Assert.assertEquals((Object)PASSWORD, (Object)connector.getKeyPassword());
        Assert.assertEquals((Object)PASSWORD, (Object)connector.getKeyStorePassword());
        Assert.assertTrue((boolean)connector.getClientKeyStore().endsWith("/clientKeystore"));
        Assert.assertEquals((Object)PASSWORD, (Object)connector.getClientKeyStorePassword());
        Assert.assertTrue((boolean)connector.getTrustStore().endsWith("/trustStore"));
        Assert.assertEquals((Object)PASSWORD, (Object)connector.getTrustStorePassword());
        Assert.assertTrue((boolean)connector.isExplicitTrustStoreOnly());
        Assert.assertTrue((boolean)connector.isRequireClientAuthentication());
    }

    @Test
    public void testTlsContextProperties() throws Exception {
        DefaultTlsContextFactory tlsContextFactory = (DefaultTlsContextFactory)muleContext.getRegistry().get("tlsContext");
        Assert.assertThat((Object)tlsContextFactory.getEnabledProtocols(), (Matcher)Matchers.is((Object)new String[]{"TLSv1"}));
        Assert.assertThat((Object)tlsContextFactory.getEnabledCipherSuites(), (Matcher)Matchers.is((Object)new String[]{"TLS_DHE_DSS_WITH_AES_128_CBC_SHA"}));
        Assert.assertThat((Object)tlsContextFactory.getTrustStorePath(), (Matcher)CoreMatchers.endsWith((String)"trustStore"));
        Assert.assertThat((Object)tlsContextFactory.getTrustStorePassword(), (Matcher)CoreMatchers.equalTo((Object)PASSWORD));
        Assert.assertThat((Object)tlsContextFactory.getTrustStoreType(), (Matcher)CoreMatchers.equalTo((Object)TYPE));
        Assert.assertThat((Object)tlsContextFactory.getTrustManagerAlgorithm(), (Matcher)CoreMatchers.equalTo((Object)ALGORITHM));
        Assert.assertThat((Object)tlsContextFactory.getKeyStorePath(), (Matcher)CoreMatchers.endsWith((String)"serverKeystore"));
        Assert.assertThat((Object)tlsContextFactory.getKeyStorePassword(), (Matcher)CoreMatchers.equalTo((Object)PASSWORD));
        Assert.assertThat((Object)tlsContextFactory.getKeyStoreType(), (Matcher)CoreMatchers.equalTo((Object)TYPE));
        Assert.assertThat((Object)tlsContextFactory.getKeyManagerPassword(), (Matcher)CoreMatchers.equalTo((Object)PASSWORD));
        Assert.assertThat((Object)tlsContextFactory.getKeyManagerAlgorithm(), (Matcher)CoreMatchers.equalTo((Object)ALGORITHM));
        Assert.assertThat((Object)tlsContextFactory.getKeyAlias(), (Matcher)CoreMatchers.equalTo((Object)ALIAS));
        Assert.assertThat((Object)tlsContextFactory.isTrustStoreInsecure(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testTlsContextKeyStoreProperties() throws Exception {
        TlsContextFactory tlsContextFactory = (TlsContextFactory)muleContext.getRegistry().get("tlsContext");
        TlsContextKeyStoreConfiguration keyStoreConfig = tlsContextFactory.getKeyStoreConfiguration();
        Assert.assertThat((Object)keyStoreConfig.getPath(), (Matcher)CoreMatchers.endsWith((String)"serverKeystore"));
        Assert.assertThat((Object)keyStoreConfig.getPassword(), (Matcher)CoreMatchers.equalTo((Object)PASSWORD));
        Assert.assertThat((Object)keyStoreConfig.getType(), (Matcher)CoreMatchers.equalTo((Object)TYPE));
        Assert.assertThat((Object)keyStoreConfig.getKeyPassword(), (Matcher)CoreMatchers.equalTo((Object)PASSWORD));
        Assert.assertThat((Object)keyStoreConfig.getAlgorithm(), (Matcher)CoreMatchers.equalTo((Object)ALGORITHM));
        Assert.assertThat((Object)keyStoreConfig.getAlias(), (Matcher)CoreMatchers.equalTo((Object)ALIAS));
    }

    @Test
    public void testTlsContextTrustStoreProperties() throws Exception {
        TlsContextFactory tlsContextFactory = (TlsContextFactory)muleContext.getRegistry().get("tlsContext");
        TlsContextTrustStoreConfiguration trustStoreConfig = tlsContextFactory.getTrustStoreConfiguration();
        Assert.assertThat((Object)trustStoreConfig.getPath(), (Matcher)CoreMatchers.endsWith((String)"trustStore"));
        Assert.assertThat((Object)trustStoreConfig.getPassword(), (Matcher)CoreMatchers.equalTo((Object)PASSWORD));
        Assert.assertThat((Object)trustStoreConfig.getType(), (Matcher)CoreMatchers.equalTo((Object)TYPE));
        Assert.assertThat((Object)trustStoreConfig.getAlgorithm(), (Matcher)CoreMatchers.equalTo((Object)ALGORITHM));
        Assert.assertThat((Object)trustStoreConfig.isInsecure(), (Matcher)CoreMatchers.equalTo((Object)false));
    }
}

