/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ssl;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.ssl.SaveCertificateCallback;

public class SslCertificateTestCase
extends FunctionalTestCase {
    private static int NUM_MESSAGES = 100;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigFile() {
        return "ssl-certificate-test.xml";
    }

    @Test
    public void testOnce() throws Exception {
        this.doTests(1);
    }

    @Test
    public void testMany() throws Exception {
        this.doTests(NUM_MESSAGES);
    }

    protected void doTests(int n) throws Exception {
        FunctionalTestComponent ftc = (FunctionalTestComponent)this.getComponent("service");
        Assert.assertNotNull((Object)ftc);
        Assert.assertNotNull((Object)ftc.getEventCallback());
        SaveCertificateCallback callback = (SaveCertificateCallback)ftc.getEventCallback();
        callback.clear();
        LocalMuleClient client = muleContext.getClient();
        for (int i = 0; i < n; ++i) {
            callback.clear();
            String msg = "Test Message" + n;
            MuleMessage result = client.send("in", (Object)msg, null);
            Assert.assertTrue((boolean)callback.isCalled());
            Assert.assertNotNull((String)"Null certificates", (Object)callback.getCertificates());
            Assert.assertEquals((Object)(msg + " Received"), (Object)result.getPayloadAsString());
        }
    }
}

