/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.stdio;

import java.io.InputStream;
import java.io.OutputStream;
import org.mule.config.i18n.MessageFactory;
import org.mule.providers.stdio.StdioConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.util.StringUtils;

public class PromptStdioConnector
extends StdioConnector {
    private String promptMessage;
    private String promptMessageCode = null;
    private String resourceBundle = null;
    private String outputMessage;
    private String outputMessageCode = null;
    private long messageDelayTime = 3000L;
    private boolean firstTime = true;

    public PromptStdioConnector() {
        this.inputStream = System.in;
        this.outputStream = System.out;
    }

    protected void doInitialise() throws InitialisationException {
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void doStart() {
        this.firstTime = false;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public String getPromptMessage() {
        if (StringUtils.isNotBlank((String)this.resourceBundle) && StringUtils.isNotBlank((String)this.promptMessageCode)) {
            return StdioMessageFactory.getString(this.resourceBundle, this.promptMessageCode);
        }
        return this.promptMessage;
    }

    public void setPromptMessage(String promptMessage) {
        this.promptMessage = promptMessage;
    }

    public String getPromptMessageCode() {
        return this.promptMessageCode;
    }

    public void setPromptMessageCode(String promptMessageCode) {
        this.promptMessageCode = promptMessageCode;
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(String resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public String getOutputMessage() {
        if (StringUtils.isNotBlank((String)this.resourceBundle) && StringUtils.isNotBlank((String)this.outputMessageCode)) {
            return StdioMessageFactory.getString(this.resourceBundle, this.outputMessageCode);
        }
        return this.outputMessage;
    }

    public void setOutputMessage(String outputMessage) {
        this.outputMessage = outputMessage;
    }

    public String getOutputMessageCode() {
        return this.outputMessageCode;
    }

    public void setOutputMessageCode(String outputMessageCode) {
        this.outputMessageCode = outputMessageCode;
    }

    public UMOConnector getConnector() {
        return this;
    }

    public UMOMessageReceiver registerListener(UMOComponent component, UMOImmutableEndpoint endpoint) throws Exception {
        if (this.receivers.size() > 0) {
            throw new UnsupportedOperationException("You can only register one listener per system stream connector");
        }
        UMOMessageReceiver receiver = super.registerListener(component, endpoint);
        return receiver;
    }

    public long getMessageDelayTime() {
        if (this.firstTime) {
            return this.messageDelayTime + 4000L;
        }
        return this.messageDelayTime;
    }

    public void setMessageDelayTime(long messageDelayTime) {
        this.messageDelayTime = messageDelayTime;
    }

    public OutputStream getOutputStream(UMOImmutableEndpoint endpoint, UMOMessage message) throws UMOException {
        String streamName = endpoint.getEndpointURI().getAddress();
        OutputStream out = "system.out".equalsIgnoreCase(streamName) ? System.out : ("system.err".equalsIgnoreCase(streamName) ? System.err : this.getOutputStream());
        return out;
    }

    private static class StdioMessageFactory
    extends MessageFactory {
        private StdioMessageFactory() {
        }

        protected static String getString(String bundlePath, String code) {
            return MessageFactory.getString((String)bundlePath, (int)Integer.parseInt(code));
        }
    }
}

