/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.stdio;

import java.io.InputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import org.apache.commons.lang.SystemUtils;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractPollingMessageReceiver;
import org.mule.providers.stdio.PromptStdioConnector;
import org.mule.providers.stdio.StdioConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.CreateException;
import org.mule.umo.provider.UMOConnector;

public class StdioMessageReceiver
extends AbstractPollingMessageReceiver {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private int bufferSize = 4096;
    private InputStream inputStream;
    private StdioConnector connector;

    public StdioMessageReceiver(UMOConnector connector, UMOComponent component, UMOImmutableEndpoint endpoint, long checkFrequency) throws CreateException {
        super(connector, component, endpoint);
        this.setFrequency(checkFrequency);
        this.connector = (StdioConnector)connector;
        String streamName = endpoint.getEndpointURI().getAddress();
        this.inputStream = "system.in".equalsIgnoreCase(streamName) ? System.in : this.connector.getInputStream();
        if (connector instanceof PromptStdioConnector) {
            PromptStdioConnector ssc = (PromptStdioConnector)connector;
            String promptMessage = (String)endpoint.getProperties().get("promptMessage");
            if (promptMessage != null) {
                ssc.setPromptMessage(promptMessage);
            }
        }
    }

    protected void doDispose() {
    }

    public void doConnect() throws Exception {
        if (this.connector instanceof PromptStdioConnector) {
            PromptStdioConnector ssc = (PromptStdioConnector)this.connector;
            DelayedMessageWriter writer = new DelayedMessageWriter(ssc);
            writer.start();
        }
    }

    public void doDisconnect() throws Exception {
    }

    public void poll() {
        try {
            if (this.endpoint.isStreaming()) {
                PushbackInputStream in = new PushbackInputStream(this.inputStream);
                int i = in.read();
                in.unread(i);
                MuleMessage umoMessage = new MuleMessage((Object)this.connector.getStreamMessageAdapter(in, null));
                this.routeMessage((UMOMessage)umoMessage, this.endpoint.isSynchronous());
            } else {
                byte[] inputBuffer = new byte[this.bufferSize];
                int len = this.inputStream.read(inputBuffer);
                if (len == -1) {
                    return;
                }
                StringBuffer fullBuffer = new StringBuffer(this.bufferSize);
                while (len > 0) {
                    fullBuffer.append(new String(inputBuffer, 0, len));
                    len = 0;
                    if (this.inputStream.available() <= 0) continue;
                    len = this.inputStream.read(inputBuffer);
                }
                int noCRLFLength = fullBuffer.length() - SystemUtils.LINE_SEPARATOR.length();
                String finalMessageString = fullBuffer.indexOf(SystemUtils.LINE_SEPARATOR, noCRLFLength) != -1 ? fullBuffer.substring(0, noCRLFLength) : fullBuffer.toString();
                MuleMessage umoMessage = new MuleMessage((Object)this.connector.getMessageAdapter(finalMessageString));
                this.routeMessage((UMOMessage)umoMessage, this.endpoint.isSynchronous());
            }
            this.doConnect();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    private class DelayedMessageWriter
    extends Thread {
        private long delay = 0L;
        private PromptStdioConnector ssc;

        public DelayedMessageWriter(PromptStdioConnector ssc) {
            this.delay = ssc.getMessageDelayTime();
            this.ssc = ssc;
        }

        public void run() {
            if (this.delay > 0L) {
                try {
                    DelayedMessageWriter.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ((PrintStream)this.ssc.getOutputStream()).println();
            ((PrintStream)this.ssc.getOutputStream()).print(this.ssc.getPromptMessage());
        }
    }
}

