/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.stdio;

import java.io.OutputStream;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.stdio.PromptStdioConnector;
import org.mule.providers.stdio.StdioConnector;
import org.mule.providers.stdio.i18n.StdioMessages;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.DispatchException;
import org.mule.util.StringUtils;

public class StdioMessageDispatcher
extends AbstractMessageDispatcher {
    private final StdioConnector connector;

    public StdioMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (StdioConnector)endpoint.getConnector();
        if (this.connector instanceof PromptStdioConnector) {
            PromptStdioConnector ssc = (PromptStdioConnector)this.connector;
            String outputMessage = (String)endpoint.getProperties().get("outputMessage");
            if (outputMessage != null) {
                ssc.setOutputMessage(outputMessage);
            }
        }
    }

    protected synchronized void doDispatch(UMOEvent event) throws Exception {
        Object data;
        PromptStdioConnector ssc;
        OutputStream out = this.connector.getOutputStream();
        if (out == null) {
            throw new DispatchException(StdioMessages.couldNotFindStreamWithName(event.getEndpoint().getEndpointURI().getAddress()), event.getMessage(), event.getEndpoint());
        }
        if (this.connector instanceof PromptStdioConnector && StringUtils.isNotBlank((String)(ssc = (PromptStdioConnector)this.connector).getOutputMessage())) {
            out.write(ssc.getOutputMessage().getBytes());
        }
        if ((data = event.getTransformedMessage()) instanceof byte[]) {
            out.write((byte[])data);
        } else {
            out.write(data.toString().getBytes());
        }
        out.flush();
    }

    protected UMOMessage doSend(UMOEvent event) throws Exception {
        this.doDispatch(event);
        return event.getMessage();
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }
}

