/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.stdio;

import java.io.InputStream;
import java.io.OutputStream;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.config.i18n.MessageFactory;
import org.mule.transport.stdio.StdioConnector;
import org.mule.util.StringUtils;

public class PromptStdioConnector
extends StdioConnector {
    private String promptMessage;
    private String promptMessageCode = null;
    private String resourceBundle = null;
    private String outputMessage;
    private String outputMessageCode = null;
    private long messageDelayTime = 3000L;
    private boolean firstTime = true;

    public PromptStdioConnector() {
        this.inputStream = System.in;
        this.outputStream = System.out;
    }

    protected void doInitialise() throws InitialisationException {
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void doStart() {
        this.firstTime = false;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public String getPromptMessage() {
        if (StringUtils.isNotBlank((String)this.resourceBundle) && StringUtils.isNotBlank((String)this.promptMessageCode)) {
            return StdioMessageFactory.getString(this.resourceBundle, this.promptMessageCode);
        }
        return this.promptMessage;
    }

    public void setPromptMessage(String promptMessage) {
        this.promptMessage = promptMessage;
    }

    public String getPromptMessageCode() {
        return this.promptMessageCode;
    }

    public void setPromptMessageCode(String promptMessageCode) {
        this.promptMessageCode = promptMessageCode;
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(String resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public String getOutputMessage() {
        if (StringUtils.isNotBlank((String)this.resourceBundle) && StringUtils.isNotBlank((String)this.outputMessageCode)) {
            return StdioMessageFactory.getString(this.resourceBundle, this.outputMessageCode);
        }
        return this.outputMessage;
    }

    public void setOutputMessage(String outputMessage) {
        this.outputMessage = outputMessage;
    }

    public String getOutputMessageCode() {
        return this.outputMessageCode;
    }

    public void setOutputMessageCode(String outputMessageCode) {
        this.outputMessageCode = outputMessageCode;
    }

    public Connector getConnector() {
        return this;
    }

    public MessageReceiver registerListener(Service service, InboundEndpoint endpoint) throws Exception {
        if (this.receivers.size() > 0) {
            throw new UnsupportedOperationException("You can only register one listener per system stream connector");
        }
        MessageReceiver receiver = super.registerListener(service, endpoint);
        return receiver;
    }

    public long getMessageDelayTime() {
        if (this.firstTime) {
            return this.messageDelayTime + 4000L;
        }
        return this.messageDelayTime;
    }

    public void setMessageDelayTime(long messageDelayTime) {
        this.messageDelayTime = messageDelayTime;
    }

    public OutputStream getOutputStream(ImmutableEndpoint endpoint, MuleMessage message) throws MuleException {
        String streamName = endpoint.getEndpointURI().getAddress();
        OutputStream out = "system.out".equalsIgnoreCase(streamName) ? System.out : ("system.err".equalsIgnoreCase(streamName) ? System.err : this.getOutputStream());
        return out;
    }

    private static class StdioMessageFactory
    extends MessageFactory {
        private StdioMessageFactory() {
        }

        protected static String getString(String bundlePath, String code) {
            return MessageFactory.getString((String)bundlePath, (int)Integer.parseInt(code));
        }
    }
}

