/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.stdio;

import java.io.OutputStream;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transport.DispatchException;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.stdio.PromptStdioConnector;
import org.mule.transport.stdio.StdioConnector;
import org.mule.transport.stdio.i18n.StdioMessages;
import org.mule.util.StringUtils;

public class StdioMessageDispatcher
extends AbstractMessageDispatcher {
    private final StdioConnector connector;

    public StdioMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (StdioConnector)endpoint.getConnector();
        if (this.connector instanceof PromptStdioConnector) {
            PromptStdioConnector ssc = (PromptStdioConnector)this.connector;
            String outputMessage = (String)endpoint.getProperties().get("outputMessage");
            if (outputMessage != null) {
                ssc.setOutputMessage(outputMessage);
            }
        }
    }

    protected synchronized void doDispatch(MuleEvent event) throws Exception {
        Object data;
        PromptStdioConnector ssc;
        OutputStream out = this.connector.getOutputStream();
        if (out == null) {
            throw new DispatchException(StdioMessages.couldNotFindStreamWithName(event.getEndpoint().getEndpointURI().getAddress()), event.getMessage(), event.getEndpoint());
        }
        if (this.connector instanceof PromptStdioConnector && StringUtils.isNotBlank((String)(ssc = (PromptStdioConnector)this.connector).getOutputMessage())) {
            out.write(ssc.getOutputMessage().getBytes());
        }
        if ((data = event.transformMessage()) instanceof byte[]) {
            out.write((byte[])data);
        } else {
            out.write(data.toString().getBytes());
        }
        out.flush();
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        this.doDispatch(event);
        return event.getMessage();
    }
}

