/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.stdio;

import java.io.InputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.SystemUtils;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.stdio.PromptStdioConnector;
import org.mule.transport.stdio.StdioConnector;

public class StdioMessageReceiver
extends AbstractPollingMessageReceiver {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private int bufferSize = 4096;
    private InputStream inputStream;
    private StdioConnector connector;
    private boolean sendStream;

    public StdioMessageReceiver(Connector connector, Service service, InboundEndpoint endpoint, long checkFrequency) throws CreateException {
        super(connector, service, endpoint);
        this.setFrequency(checkFrequency);
        this.connector = (StdioConnector)connector;
        String streamName = endpoint.getEndpointURI().getAddress();
        this.inputStream = "system.in".equalsIgnoreCase(streamName) ? System.in : this.connector.getInputStream();
        if (connector instanceof PromptStdioConnector) {
            PromptStdioConnector ssc = (PromptStdioConnector)connector;
            String promptMessage = (String)endpoint.getProperties().get("promptMessage");
            if (promptMessage != null) {
                ssc.setPromptMessage(promptMessage);
            }
        }
        this.sendStream = BooleanUtils.toBoolean((String)((String)endpoint.getProperties().get("sendStream")));
    }

    protected void doDispose() {
    }

    public void doConnect() throws Exception {
        if (this.connector instanceof PromptStdioConnector) {
            PromptStdioConnector ssc = (PromptStdioConnector)this.connector;
            DelayedMessageWriter writer = new DelayedMessageWriter(ssc);
            writer.start();
        }
    }

    public void doDisconnect() throws Exception {
    }

    public void poll() {
        String encoding = this.endpoint.getEncoding();
        try {
            if (this.sendStream) {
                PushbackInputStream in = new PushbackInputStream(this.inputStream);
                int i = in.read();
                in.unread(i);
                MuleMessage message = this.createMuleMessage(in, encoding);
                this.routeMessage(message, this.endpoint.isSynchronous());
            } else {
                byte[] inputBuffer = new byte[this.bufferSize];
                int len = this.inputStream.read(inputBuffer);
                if (len == -1) {
                    return;
                }
                StringBuffer fullBuffer = new StringBuffer(this.bufferSize);
                while (len > 0) {
                    fullBuffer.append(new String(inputBuffer, 0, len));
                    len = 0;
                    if (this.inputStream.available() <= 0) continue;
                    len = this.inputStream.read(inputBuffer);
                }
                String[] lines = fullBuffer.toString().split(SystemUtils.LINE_SEPARATOR);
                for (int i = 0; i < lines.length; ++i) {
                    MuleMessage message = this.createMuleMessage(lines[i], encoding);
                    this.routeMessage(message, this.endpoint.isSynchronous());
                }
            }
            this.doConnect();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    private class DelayedMessageWriter
    extends Thread {
        private long delay = 0L;
        private PromptStdioConnector ssc;

        public DelayedMessageWriter(PromptStdioConnector ssc) {
            this.delay = ssc.getMessageDelayTime();
            this.ssc = ssc;
        }

        public void run() {
            if (this.delay > 0L) {
                try {
                    DelayedMessageWriter.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ((PrintStream)this.ssc.getOutputStream()).println();
            ((PrintStream)this.ssc.getOutputStream()).print(this.ssc.getPromptMessage());
        }
    }
}

