/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.stdio;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.stdio.PromptStdioConnector;

public class StdioNamespaceHandlerTestCase
extends AbstractServiceAndFlowTestCase {
    public StdioNamespaceHandlerTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "stdio-namespace-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "stdio-namespace-config-flow.xml"});
    }

    @Test
    public void testConfig() throws Exception {
        PromptStdioConnector c = (PromptStdioConnector)muleContext.getRegistry().lookupConnector("stdioConnector");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)1234L, (long)c.getMessageDelayTime());
        Assert.assertEquals((Object)"abc", (Object)c.getOutputMessage());
        Assert.assertEquals((Object)"edc", (Object)c.getPromptMessage());
        Assert.assertEquals((Object)"456", (Object)c.getPromptMessageCode());
        Assert.assertEquals((Object)"dummy-messages", (Object)c.getResourceBundle());
        Assert.assertTrue((boolean)c.isConnected());
        Assert.assertTrue((boolean)c.isStarted());
    }

    @Test
    public void testNoBundle() throws Exception {
        PromptStdioConnector c = (PromptStdioConnector)muleContext.getRegistry().lookupConnector("noBundleConnector");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)1234L, (long)c.getMessageDelayTime());
        Assert.assertEquals((Object)"abc", (Object)c.getOutputMessage());
        Assert.assertEquals((Object)"bcd", (Object)c.getPromptMessage());
        Assert.assertTrue((boolean)c.isConnected());
        Assert.assertTrue((boolean)c.isStarted());
    }

    @Test
    public void testSystemAttributeMap() {
        this.testEndpointAttribute("in", "system.in");
        this.testEndpointAttribute("out", "system.out");
        this.testEndpointAttribute("err", "system.err");
    }

    protected void testEndpointAttribute(String name, String address) {
        ImmutableEndpoint endpoint = (ImmutableEndpoint)muleContext.getRegistry().lookupObject(name);
        Assert.assertNotNull((String)("Null " + name), (Object)endpoint);
        Assert.assertEquals((Object)address, (Object)endpoint.getEndpointURI().getAddress());
    }
}

