/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.stdio;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.Connector;
import org.mule.transport.AbstractConnectorTestCase;
import org.mule.transport.stdio.PromptStdioConnector;

public class PromptStdioConnectorTestCase
extends AbstractConnectorTestCase {
    public String getTestEndpointURI() {
        return "stdio://System.out";
    }

    public Connector createConnector() throws Exception {
        PromptStdioConnector cnn = new PromptStdioConnector(muleContext);
        cnn.setName("TestStdio");
        return cnn;
    }

    public Object getValidMessage() throws Exception {
        return "Test Message";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContextClassLoaderResourceLookup() throws InitialisationException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        PromptStdioConnector connector = new PromptStdioConnector(muleContext);
        connector.setResourceBundle("dummy-messages");
        connector.setPromptMessageCode("1");
        connector.setOutputMessageCode("2");
        try {
            Thread.currentThread().setContextClassLoader(new ContextClassLoaderTestClassLoader());
            connector.doInitialise();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        Assert.assertEquals((Object)"Test ContextClassLoader Prompt Message", (Object)connector.getPromptMessage());
        Assert.assertEquals((Object)"Test ContextClassLoader Output Message", (Object)connector.getOutputMessage());
    }

    private class ContextClassLoaderTestClassLoader
    extends ClassLoader {
        @Override
        public InputStream getResourceAsStream(String name) {
            String messages = "1=Test ContextClassLoader Prompt Message\n2=Test ContextClassLoader Output Message";
            return new ByteArrayInputStream(messages.getBytes());
        }
    }
}

