/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.udp;

import java.net.DatagramSocket;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.providers.AbstractConnector;
import org.mule.providers.udp.UdpSocketFactory;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;

public class UdpConnector
extends AbstractConnector {
    public static final int DEFAULT_SOCKET_TIMEOUT = -1;
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    public static final String KEEP_SEND_SOCKET_OPEN_PROPERTY = "keepSendSocketOpen";
    protected int sendTimeout = -1;
    protected int receiveTimeout = -1;
    protected int sendBufferSize = 16384;
    protected int receiveBufferSize = 16384;
    protected boolean keepSendSocketOpen = true;
    protected boolean broadcast;
    protected GenericKeyedObjectPool dispatcherSocketsPool = new GenericKeyedObjectPool();

    protected void doInitialise() throws InitialisationException {
        this.dispatcherSocketsPool.setFactory((KeyedPoolableObjectFactory)new UdpSocketFactory());
        this.dispatcherSocketsPool.setTestOnBorrow(true);
        this.dispatcherSocketsPool.setTestOnReturn(true);
        this.dispatcherSocketsPool.setMaxActive(1);
    }

    protected void doDispose() {
        try {
            this.dispatcherSocketsPool.close();
        }
        catch (Exception e) {
            this.logger.warn((Object)("Failed to close dispatcher socket pool: " + e.getMessage()));
        }
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
        this.dispatcherSocketsPool.clear();
    }

    protected void doStart() throws UMOException {
    }

    protected void doStop() throws UMOException {
    }

    public String getProtocol() {
        return "udp";
    }

    public int getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(int timeout) {
        if (timeout < 0) {
            timeout = -1;
        }
        this.sendTimeout = timeout;
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(int timeout) {
        if (timeout < 0) {
            timeout = -1;
        }
        this.receiveTimeout = timeout;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        if (sendBufferSize < 1) {
            sendBufferSize = 16384;
        }
        this.sendBufferSize = sendBufferSize;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        if (receiveBufferSize < 1) {
            receiveBufferSize = 16384;
        }
        this.receiveBufferSize = receiveBufferSize;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public boolean isKeepSendSocketOpen() {
        return this.keepSendSocketOpen;
    }

    public void setKeepSendSocketOpen(boolean keepSendSocketOpen) {
        this.keepSendSocketOpen = keepSendSocketOpen;
    }

    DatagramSocket getSocket(UMOImmutableEndpoint endpoint) throws Exception {
        return (DatagramSocket)this.dispatcherSocketsPool.borrowObject((Object)endpoint);
    }

    void releaseSocket(DatagramSocket socket, UMOImmutableEndpoint endpoint) throws Exception {
        this.dispatcherSocketsPool.returnObject((Object)endpoint, (Object)socket);
    }

    protected Object getReceiverKey(UMOComponent component, UMOImmutableEndpoint endpoint) {
        return endpoint.getEndpointURI().getAddress() + "/" + component.getName();
    }
}

