/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Map;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.udp.UdpConnector;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.UMOMessageAdapter;

public class UdpMessageDispatcher
extends AbstractMessageDispatcher {
    protected final UdpConnector connector;

    public UdpMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (UdpConnector)endpoint.getConnector();
    }

    protected void doConnect() throws Exception {
        DatagramSocket socket = this.connector.getSocket(this.endpoint);
        this.connector.releaseSocket(socket, this.endpoint);
    }

    protected void doDisconnect() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doDispatch(UMOEvent event) throws Exception {
        UMOImmutableEndpoint ep = event.getEndpoint();
        DatagramSocket socket = this.connector.getSocket(ep);
        try {
            byte[] payload = event.getTransformedMessageAsBytes();
            int port = ep.getEndpointURI().getPort();
            InetAddress inetAddress = null;
            inetAddress = "null".equalsIgnoreCase(ep.getEndpointURI().getHost()) ? InetAddress.getLocalHost() : InetAddress.getByName(ep.getEndpointURI().getHost());
            this.write(socket, payload, port, inetAddress);
        }
        finally {
            this.connector.releaseSocket(socket, ep);
        }
    }

    protected void write(DatagramSocket socket, byte[] data, int port, InetAddress inetAddress) throws IOException {
        DatagramPacket packet = new DatagramPacket(data, data.length);
        if (port >= 0) {
            packet.setPort(port);
        }
        packet.setAddress(inetAddress);
        socket.send(packet);
    }

    protected synchronized UMOMessage doSend(UMOEvent event) throws Exception {
        this.doDispatch(event);
        if (event.getEndpoint().isRemoteSync()) {
            DatagramSocket socket = this.connector.getSocket(event.getEndpoint());
            DatagramPacket result = this.receive(socket, event.getTimeout());
            if (result == null) {
                return null;
            }
            return new MuleMessage((Object)this.connector.getMessageAdapter(result), (UMOMessageAdapter)event.getMessage());
        }
        return event.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatagramPacket receive(DatagramSocket socket, int timeout) throws IOException {
        DatagramPacket datagramPacket;
        int origTimeout = socket.getSoTimeout();
        try {
            DatagramPacket packet = new DatagramPacket(new byte[this.connector.getReceiveBufferSize()], this.connector.getReceiveBufferSize());
            if (timeout > 0 && timeout != socket.getSoTimeout()) {
                socket.setSoTimeout(timeout);
            }
            socket.receive(packet);
            datagramPacket = packet;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var7_7 = null;
                if (socket.getSoTimeout() == origTimeout) break block4;
                socket.setSoTimeout(origTimeout);
            }
            throw throwable;
        }
        if (socket.getSoTimeout() != origTimeout) {
            socket.setSoTimeout(origTimeout);
        }
        return datagramPacket;
    }

    protected UMOMessage doReceive(long timeout) throws Exception {
        DatagramSocket socket = this.connector.getSocket(this.endpoint);
        DatagramPacket result = this.receive(socket, (int)timeout);
        if (result == null) {
            return null;
        }
        return new MuleMessage((Object)this.connector.getMessageAdapter(result), (Map)null);
    }

    protected void doDispose() {
    }
}

