/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.ConnectException;
import org.mule.providers.udp.UdpConnector;
import org.mule.providers.udp.i18n.UdpMessages;
import org.mule.transformers.TransformerUtils;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.CreateException;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.provider.UMOConnectable;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;

public class UdpMessageReceiver
extends AbstractMessageReceiver
implements Work {
    protected DatagramSocket socket = null;
    protected InetAddress inetAddress;
    protected int bufferSize;
    private URI uri;
    protected List responseTransformers = null;

    public UdpMessageReceiver(UMOConnector connector, UMOComponent component, UMOImmutableEndpoint endpoint) throws CreateException {
        super(connector, component, endpoint);
        this.bufferSize = ((UdpConnector)connector).getReceiveBufferSize();
        this.uri = endpoint.getEndpointURI().getUri();
        try {
            if (!"null".equalsIgnoreCase(this.uri.getHost())) {
                this.inetAddress = InetAddress.getByName(this.uri.getHost());
            }
        }
        catch (UnknownHostException e) {
            throw new CreateException(UdpMessages.failedToLocateHost(this.uri), (Throwable)e, (Object)this);
        }
        this.responseTransformers = this.getResponseTransformers();
    }

    protected void doConnect() throws Exception {
        try {
            this.socket = ((UdpConnector)this.connector).getSocket(this.endpoint);
        }
        catch (Exception e) {
            throw new ConnectException(UdpMessages.failedToBind(this.uri), (Throwable)e, (UMOConnectable)this);
        }
        try {
            this.getWorkManager().scheduleWork((Work)this, Long.MAX_VALUE, null, (WorkListener)this.connector);
        }
        catch (WorkException e) {
            throw new ConnectException(CoreMessages.failedToScheduleWork(), (Throwable)e, (UMOConnectable)this);
        }
    }

    protected void doDisconnect() throws Exception {
        this.disposing.set(true);
        if (this.socket != null) {
            this.socket.close();
        }
    }

    protected void doStart() throws UMOException {
    }

    protected void doStop() throws UMOException {
    }

    protected List getResponseTransformers() {
        List transformers = this.endpoint.getResponseTransformers();
        if (transformers == null) {
            return this.connector.getDefaultResponseTransformers();
        }
        return transformers;
    }

    protected DatagramSocket createSocket(URI uri, InetAddress inetAddress) throws IOException {
        return new DatagramSocket(uri.getPort(), inetAddress);
    }

    public DatagramSocket getSocket() {
        return this.socket;
    }

    protected DatagramPacket createPacket() {
        DatagramPacket packet = new DatagramPacket(new byte[this.bufferSize], this.bufferSize);
        return packet;
    }

    public void run() {
        while (!this.disposing.get()) {
            if (!this.connector.isStarted()) continue;
            try {
                DatagramPacket packet = this.createPacket();
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Receiving packet on " + this.uri));
                    }
                    this.socket.receive(packet);
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Received packet on: " + this.uri));
                    }
                    Work work = this.createWork(packet);
                    try {
                        this.getWorkManager().scheduleWork(work, Long.MAX_VALUE, null, (WorkListener)this.connector);
                    }
                    catch (WorkException e) {
                        this.logger.error((Object)("Udp receiver interrupted: " + e.getMessage()), (Throwable)e);
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
            }
            catch (Exception e) {
                if (this.connector.isDisposed() || this.disposing.get()) continue;
                this.logger.debug((Object)("Accept failed on socket: " + e), (Throwable)e);
                this.handleException(e);
            }
        }
    }

    public void release() {
        this.dispose();
    }

    protected void doDispose() {
        if (this.socket != null && !this.socket.isClosed()) {
            this.logger.debug((Object)("Closing Udp connection: " + this.uri));
            this.socket.close();
            this.logger.info((Object)("Closed Udp connection: " + this.uri));
        }
    }

    protected Work createWork(DatagramPacket packet) throws IOException {
        return new UdpWorker(new DatagramSocket(0), packet);
    }

    protected class UdpWorker
    implements Work,
    Disposable {
        private DatagramSocket socket = null;
        private DatagramPacket packet;

        public UdpWorker(DatagramSocket socket, DatagramPacket packet) {
            this.socket = socket;
            this.packet = packet;
        }

        public void release() {
            this.dispose();
        }

        public void dispose() {
            if (this.socket != null && !this.socket.isClosed()) {
                try {
                    this.socket.close();
                }
                catch (Exception e) {
                    UdpMessageReceiver.this.logger.error((Object)"Socket close failed", (Throwable)e);
                }
            }
            this.socket = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            UMOMessage returnMessage = null;
            try {
                UMOMessageAdapter adapter = UdpMessageReceiver.this.connector.getMessageAdapter((Object)this.packet);
                returnMessage = UdpMessageReceiver.this.routeMessage((UMOMessage)new MuleMessage((Object)adapter), UdpMessageReceiver.this.endpoint.isSynchronous());
                if (returnMessage != null) {
                    UMOMessage response;
                    byte[] data = UdpMessageReceiver.this.responseTransformers != null ? ((response = TransformerUtils.applyAllTransformers((List)UdpMessageReceiver.this.responseTransformers, (UMOMessage)returnMessage)) instanceof byte[] ? (byte[])response : response.toString().getBytes()) : returnMessage.getPayloadAsBytes();
                    DatagramPacket result = new DatagramPacket(data, data.length, this.packet.getAddress(), this.packet.getPort());
                    this.socket.send(result);
                }
            }
            catch (Exception e) {
                if (!UdpMessageReceiver.this.disposing.get()) {
                    UdpMessageReceiver.this.handleException(e);
                }
            }
            finally {
                this.dispose();
            }
        }
    }
}

