/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.udp;

import java.net.DatagramSocket;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.service.Service;
import org.mule.transport.AbstractConnector;
import org.mule.transport.udp.UdpSocketFactory;

public class UdpConnector
extends AbstractConnector {
    public static final String UDP = "udp";
    public static final int DEFAULT_SOCKET_TIMEOUT = -1;
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    public static final String KEEP_SEND_SOCKET_OPEN_PROPERTY = "keepSendSocketOpen";
    public static final String ADDRESS_PROPERTY = "packet.address";
    public static final String PORT_PROPERTY = "packet.port";
    protected int sendTimeout = -1;
    protected int receiveTimeout = -1;
    protected int sendBufferSize = 16384;
    protected int receiveBufferSize = 16384;
    protected boolean keepSendSocketOpen = true;
    protected boolean broadcast;
    protected GenericKeyedObjectPool dispatcherSocketsPool = new GenericKeyedObjectPool();
    protected UdpSocketFactory socketFactory;

    public UdpConnector(MuleContext context) {
        super(context);
    }

    protected void doInitialise() throws InitialisationException {
        this.socketFactory = new UdpSocketFactory();
        this.dispatcherSocketsPool.setFactory((KeyedPoolableObjectFactory)this.socketFactory);
        this.dispatcherSocketsPool.setTestOnBorrow(true);
        this.dispatcherSocketsPool.setTestOnReturn(true);
        this.dispatcherSocketsPool.setMaxActive(1);
    }

    protected void doDispose() {
        try {
            this.dispatcherSocketsPool.close();
        }
        catch (Exception e) {
            this.logger.warn((Object)("Failed to close dispatcher socket pool: " + e.getMessage()));
        }
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
        this.dispatcherSocketsPool.clear();
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    public String getProtocol() {
        return UDP;
    }

    public int getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(int timeout) {
        if (timeout < 0) {
            timeout = -1;
        }
        this.sendTimeout = timeout;
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(int timeout) {
        if (timeout < 0) {
            timeout = -1;
        }
        this.receiveTimeout = timeout;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        if (sendBufferSize < 1) {
            sendBufferSize = 16384;
        }
        this.sendBufferSize = sendBufferSize;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        if (receiveBufferSize < 1) {
            receiveBufferSize = 16384;
        }
        this.receiveBufferSize = receiveBufferSize;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public boolean isKeepSendSocketOpen() {
        return this.keepSendSocketOpen;
    }

    public void setKeepSendSocketOpen(boolean keepSendSocketOpen) {
        this.keepSendSocketOpen = keepSendSocketOpen;
    }

    DatagramSocket getSocket(ImmutableEndpoint endpoint) throws Exception {
        return (DatagramSocket)this.dispatcherSocketsPool.borrowObject((Object)endpoint);
    }

    DatagramSocket getServerSocket(ImmutableEndpoint endpoint) throws Exception {
        return (DatagramSocket)this.socketFactory.makeObject(endpoint);
    }

    void releaseSocket(DatagramSocket socket, ImmutableEndpoint endpoint) throws Exception {
        if (!this.keepSendSocketOpen) {
            this.dispatcherSocketsPool.clear((Object)endpoint);
        } else {
            this.dispatcherSocketsPool.returnObject((Object)endpoint, (Object)socket);
        }
    }

    protected Object getReceiverKey(Service service, InboundEndpoint endpoint) {
        return endpoint.getEndpointURI().getAddress() + "/" + service.getName();
    }
}

