/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.retry.RetryContext;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.NullPayload;
import org.mule.transport.udp.UdpConnector;

public class UdpMessageDispatcher
extends AbstractMessageDispatcher {
    protected final UdpConnector connector;

    public UdpMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (UdpConnector)endpoint.getConnector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetryContext validateConnection(RetryContext retryContext) {
        DatagramSocket socket = null;
        try {
            socket = this.connector.getSocket(this.endpoint);
            retryContext.setOk();
        }
        catch (Exception ex) {
            retryContext.setFailed((Throwable)ex);
        }
        finally {
            block13: {
                if (socket != null) {
                    try {
                        this.connector.releaseSocket(socket, this.endpoint);
                    }
                    catch (Exception e) {
                        if (!this.logger.isDebugEnabled()) break block13;
                        this.logger.debug((Object)("Failed to release a socket " + socket), (Throwable)e);
                    }
                }
            }
        }
        return retryContext;
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doDispatch(MuleEvent event) throws Exception {
        ImmutableEndpoint ep = event.getEndpoint();
        DatagramSocket socket = this.connector.getSocket(ep);
        try {
            byte[] payload = event.transformMessageToBytes();
            int port = ep.getEndpointURI().getPort();
            InetAddress inetAddress = null;
            inetAddress = "null".equalsIgnoreCase(ep.getEndpointURI().getHost()) ? InetAddress.getLocalHost() : InetAddress.getByName(ep.getEndpointURI().getHost());
            this.write(socket, payload, port, inetAddress);
        }
        finally {
            this.connector.releaseSocket(socket, ep);
        }
    }

    protected void write(DatagramSocket socket, byte[] data, int port, InetAddress inetAddress) throws IOException {
        DatagramPacket packet = new DatagramPacket(data, data.length);
        if (port >= 0) {
            packet.setPort(port);
        }
        packet.setAddress(inetAddress);
        socket.send(packet);
    }

    protected synchronized MuleMessage doSend(MuleEvent event) throws Exception {
        this.doDispatch(event);
        if (event.getEndpoint().isSynchronous()) {
            DatagramSocket socket = this.connector.getSocket(event.getEndpoint());
            DatagramPacket result = this.receive(socket, event.getTimeout());
            if (result == null) {
                return this.createNullMuleMessage();
            }
            return this.createMuleMessage(result, event.getMessage(), this.endpoint.getEncoding());
        }
        return new DefaultMuleMessage((Object)NullPayload.getInstance(), this.connector.getMuleContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatagramPacket receive(DatagramSocket socket, int timeout) throws IOException {
        int origTimeout = socket.getSoTimeout();
        try {
            DatagramPacket packet = new DatagramPacket(new byte[this.connector.getReceiveBufferSize()], this.connector.getReceiveBufferSize());
            if (timeout > 0 && timeout != socket.getSoTimeout()) {
                socket.setSoTimeout(timeout);
            }
            socket.receive(packet);
            DatagramPacket datagramPacket = packet;
            return datagramPacket;
        }
        finally {
            if (socket.getSoTimeout() != origTimeout) {
                socket.setSoTimeout(origTimeout);
            }
        }
    }

    protected void doDispose() {
    }
}

