/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.xfire;

import org.codehaus.xfire.DefaultXFire;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.annotations.AnnotationServiceFactory;
import org.codehaus.xfire.annotations.WebAnnotations;
import org.codehaus.xfire.service.ServiceFactory;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.internal.notifications.ModelNotificationListener;
import org.mule.impl.internal.notifications.NotificationException;
import org.mule.providers.AbstractServiceEnabledConnector;
import org.mule.providers.soap.xfire.MuleObjectServiceFactory;
import org.mule.providers.soap.xfire.XFireServiceComponent;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.manager.UMOServerNotificationListener;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.util.ClassUtils;
import org.mule.util.SystemUtils;

public class XFireConnector
extends AbstractServiceEnabledConnector
implements ModelNotificationListener {
    public static final String XFIRE_SERVICE_COMPONENT_NAME = "_xfireServiceComponent";
    public static final String DEFAULT_MULE_NAMESPACE_URI = "http://www.muleumo.org";
    public static final String XFIRE_PROPERTY = "xfire";
    private static final String CLASSNAME_ANNOTATIONS = "org.codehaus.xfire.annotations.jsr181.Jsr181WebAnnotations";
    protected MuleDescriptor xfireDescriptor;
    private XFire xfire;
    private ServiceFactory serviceFactory;
    private boolean enableJSR181Annotations = false;

    public XFireConnector() {
        this.registerProtocols();
    }

    protected void registerProtocols() {
        this.registerSupportedProtocol("http");
        this.registerSupportedProtocol("https");
        this.registerSupportedProtocol("jms");
        this.registerSupportedProtocol("vm");
        this.registerSupportedProtocol("servlet");
    }

    public String getProtocol() {
        return XFIRE_PROPERTY;
    }

    public void doInitialise() throws InitialisationException {
        ObjectServiceFactory osf;
        super.doInitialise();
        try {
            MuleManager.getInstance().registerListener((UMOServerNotificationListener)this);
        }
        catch (NotificationException e) {
            throw new InitialisationException((Throwable)e, (Object)this);
        }
        if (this.xfire == null) {
            this.xfire = new DefaultXFire();
        }
        if (this.serviceFactory == null) {
            if (this.enableJSR181Annotations) {
                if (!SystemUtils.isJavaVersionAtLeast((int)150)) {
                    throw new InitialisationException(new Message(XFIRE_PROPERTY, 9), (Object)this);
                }
                try {
                    WebAnnotations wa = (WebAnnotations)ClassUtils.instanciateClass((String)CLASSNAME_ANNOTATIONS, null, ((Object)((Object)this)).getClass());
                    this.serviceFactory = new AnnotationServiceFactory(wa, this.xfire.getTransportManager());
                }
                catch (Exception ex) {
                    throw new InitialisationException(new Message(XFIRE_PROPERTY, 10, (Object)CLASSNAME_ANNOTATIONS), (Throwable)ex, (Object)this);
                }
            } else {
                this.serviceFactory = new MuleObjectServiceFactory(this.xfire.getTransportManager());
            }
        }
        if (this.serviceFactory instanceof ObjectServiceFactory && (osf = (ObjectServiceFactory)this.serviceFactory).getTransportManager() == null) {
            osf.setTransportManager(this.xfire.getTransportManager());
        }
    }

    public XFire getXfire() {
        return this.xfire;
    }

    public void setXfire(XFire xfire) {
        this.xfire = xfire;
    }

    protected void registerReceiverWithMuleService(UMOMessageReceiver receiver, UMOEndpointURI ep) throws UMOException {
        if (this.xfireDescriptor == null) {
            this.xfireDescriptor = (MuleDescriptor)MuleManager.getInstance().getModel().getDescriptor(XFIRE_SERVICE_COMPONENT_NAME);
            if (this.xfireDescriptor == null) {
                this.xfireDescriptor = this.createxfireDescriptor();
            } else {
                MuleManager.getInstance().getModel().unregisterComponent((UMODescriptor)this.xfireDescriptor);
            }
            if (this.xfireDescriptor.getProperties().get(XFIRE_PROPERTY) == null) {
                this.xfireDescriptor.getProperties().put(XFIRE_PROPERTY, this.xfire);
            }
            this.xfireDescriptor.setContainerManaged(false);
        }
        String serviceName = receiver.getComponent().getDescriptor().getName();
        String endpoint = receiver.getEndpointURI().getAddress();
        String scheme = ep.getScheme().toLowerCase();
        boolean sync = false;
        if (!receiver.getEndpoint().isSynchronousSet()) {
            if (scheme.equals("http") || scheme.equals("https") || scheme.equals("ssl") || scheme.equals("tcp")) {
                sync = true;
            }
        } else {
            sync = receiver.getEndpoint().isSynchronous();
        }
        if (scheme.equals("http") || scheme.equals("https") || scheme.equals("ssl") || scheme.equals("tcp") || scheme.equals("servlet")) {
            endpoint = endpoint + "/" + serviceName;
            receiver.getEndpoint().getProperties().put("http.method", "POST");
            receiver.getEndpoint().getProperties().put("Content-Type", "text/xml");
        }
        MuleEndpoint serviceEndpoint = new MuleEndpoint(endpoint, true);
        serviceEndpoint.setSynchronous(sync);
        serviceEndpoint.setName(ep.getScheme() + ":" + serviceName);
        serviceEndpoint.setTransformer(receiver.getEndpoint().getTransformer());
        receiver.getEndpoint().setTransformer(null);
        serviceEndpoint.setResponseTransformer(receiver.getEndpoint().getResponseTransformer());
        receiver.getEndpoint().setResponseTransformer(null);
        serviceEndpoint.setFilter(receiver.getEndpoint().getFilter());
        receiver.getEndpoint().setFilter(null);
        serviceEndpoint.setSecurityFilter(receiver.getEndpoint().getSecurityFilter());
        receiver.getEndpoint().setSecurityFilter(null);
        this.xfireDescriptor.getInboundRouter().addEndpoint((UMOEndpoint)serviceEndpoint);
    }

    protected MuleDescriptor createxfireDescriptor() {
        MuleDescriptor xfireDescriptor = (MuleDescriptor)MuleManager.getInstance().getModel().getDescriptor(XFIRE_SERVICE_COMPONENT_NAME);
        if (xfireDescriptor == null) {
            xfireDescriptor = new MuleDescriptor(XFIRE_SERVICE_COMPONENT_NAME);
            xfireDescriptor.setImplementation((Object)XFireServiceComponent.class.getName());
        }
        return xfireDescriptor;
    }

    public ServiceFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public void setServiceFactory(ObjectServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    protected Object getReceiverKey(UMOComponent component, UMOEndpoint endpoint) {
        if (endpoint.getEndpointURI().getPort() == -1) {
            return component.getDescriptor().getName();
        }
        return endpoint.getEndpointURI().getAddress() + "/" + component.getDescriptor().getName();
    }

    public boolean isEnableJSR181Annotations() {
        return this.enableJSR181Annotations;
    }

    public void setEnableJSR181Annotations(boolean enableJSR181Annotations) {
        this.enableJSR181Annotations = enableJSR181Annotations;
    }

    public void onNotification(UMOServerNotification event) {
        if (event.getAction() == 206 && !MuleManager.getInstance().getModel().isComponentRegistered(XFIRE_SERVICE_COMPONENT_NAME)) {
            try {
                if (this.xfireDescriptor == null) {
                    this.xfireDescriptor = this.createxfireDescriptor();
                }
                if (this.xfireDescriptor.getProperties().get(XFIRE_PROPERTY) == null) {
                    this.xfireDescriptor.getProperties().put(XFIRE_PROPERTY, this.xfire);
                }
                MuleManager.getInstance().getModel().registerComponent((UMODescriptor)this.xfireDescriptor);
            }
            catch (UMOException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }
}

