/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.xfire;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.StackObjectPool;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.Transport;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.FatalConnectException;
import org.mule.providers.soap.xfire.XFireClientPoolFactory;
import org.mule.providers.soap.xfire.XFireConnector;
import org.mule.providers.soap.xfire.transport.MuleUniversalTransport;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.transformer.TransformerException;
import org.mule.util.TemplateParser;

public class XFireMessageDispatcher
extends AbstractMessageDispatcher {
    protected XFireConnector connector;
    protected ObjectPool clientPool;

    public XFireMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (XFireConnector)endpoint.getConnector();
    }

    protected void doConnect(UMOImmutableEndpoint endpoint) throws Exception {
        if (this.clientPool == null) {
            XFire xfire = this.connector.getXfire();
            String serviceName = this.getServiceName(endpoint);
            Service service = xfire.getServiceRegistry().getService(serviceName);
            if (service == null) {
                throw new FatalConnectException(new Message("xfire", 8, (Object)serviceName), (Object)this);
            }
            try {
                this.clientPool = new StackObjectPool((PoolableObjectFactory)new XFireClientPoolFactory(endpoint, service, xfire));
                this.clientPool.addObject();
            }
            catch (Exception ex) {
                this.disconnect();
                throw ex;
            }
        }
    }

    protected void doDisconnect() throws Exception {
        if (this.clientPool != null) {
            this.clientPool.clear();
            this.clientPool = null;
        }
    }

    protected void doDispose() {
        this.connector = null;
    }

    protected String getMethod(UMOEvent event) throws DispatchException {
        UMOEndpointURI endpointUri = event.getEndpoint().getEndpointURI();
        String method = (String)endpointUri.getParams().get("method");
        if (method == null && (method = (String)event.getEndpoint().getProperties().get("method")) == null) {
            throw new DispatchException(new Message("soap", 4), event.getMessage(), event.getEndpoint());
        }
        return method;
    }

    protected Object[] getArgs(UMOEvent event) throws TransformerException {
        Object payload = event.getTransformedMessage();
        Object[] args = payload instanceof Object[] ? (Object[])payload : new Object[]{payload};
        UMOMessage message = event.getMessage();
        Set attachmentNames = message.getAttachmentNames();
        if (attachmentNames != null && !attachmentNames.isEmpty()) {
            ArrayList<DataHandler> attachments = new ArrayList<DataHandler>();
            Iterator i = attachmentNames.iterator();
            while (i.hasNext()) {
                attachments.add(message.getAttachment((String)i.next()));
            }
            ArrayList<Object> temp = new ArrayList<Object>(Arrays.asList(args));
            temp.add(attachments.toArray(new DataHandler[0]));
            args = temp.toArray();
        }
        return args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UMOMessage doSend(UMOEvent event) throws Exception {
        MuleMessage muleMessage;
        block6: {
            Client client = null;
            try {
                client = (Client)this.clientPool.borrowObject();
                client.setTimeout(event.getTimeout());
                client.setProperty("MULE_EVENT", (Object)event);
                String method = this.getMethod(event);
                String soapAction = (String)event.getMessage().getProperty("soapAction");
                if (soapAction != null) {
                    soapAction = this.parseSoapAction(soapAction, new QName(method), event);
                    client.setProperty("SOAPAction", (Object)soapAction);
                }
                Object[] response = client.invoke(method, this.getArgs(event));
                MuleMessage result = null;
                if (response != null && response.length <= 1) {
                    if (response.length == 1) {
                        result = new MuleMessage(response[0], (UMOMessageAdapter)event.getMessage());
                    }
                } else {
                    result = new MuleMessage((Object)response, (UMOMessageAdapter)event.getMessage());
                }
                muleMessage = result;
                Object var9_8 = null;
                if (client == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var9_9 = null;
                    if (client == null) break block7;
                    this.clientPool.returnObject((Object)client);
                }
                throw throwable;
            }
            this.clientPool.returnObject((Object)client);
        }
        return muleMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doDispatch(UMOEvent event) throws Exception {
        Client client = null;
        try {
            client = (Client)this.clientPool.borrowObject();
            client.setTimeout(event.getTimeout());
            client.setProperty("MULE_EVENT", (Object)event);
            client.invoke(this.getMethod(event), this.getArgs(event));
            Object var4_3 = null;
            if (client == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (client == null) throw throwable;
            this.clientPool.returnObject((Object)client);
            throw throwable;
        }
        this.clientPool.returnObject((Object)client);
    }

    protected UMOMessage doReceive(UMOImmutableEndpoint endpoint, long timeout) throws Exception {
        String serviceName = this.getServiceName(endpoint);
        XFire xfire = this.connector.getXfire();
        Service service = xfire.getServiceRegistry().getService(serviceName);
        Client client = new Client((Transport)new MuleUniversalTransport(), service, endpoint.getEndpointURI().toString());
        client.setXFire(xfire);
        client.setTimeout((int)timeout);
        client.setEndpointUri(endpoint.getEndpointURI().toString());
        String method = (String)endpoint.getProperty((Object)"method");
        OperationInfo op = service.getServiceInfo().getOperation(method);
        Properties params = endpoint.getEndpointURI().getUserParams();
        Object[] args = new String[params.size()];
        int i = 0;
        Iterator<Object> iterator = params.values().iterator();
        while (iterator.hasNext()) {
            args[i] = iterator.next().toString();
            ++i;
        }
        Object[] response = client.invoke(op, args);
        if (response != null && response.length == 1) {
            return new MuleMessage(response[0]);
        }
        return new MuleMessage((Object)response);
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    protected String getServiceName(UMOImmutableEndpoint endpoint) {
        String pathInfo = endpoint.getEndpointURI().getPath();
        if (StringUtils.isEmpty((String)pathInfo)) {
            return endpoint.getEndpointURI().getHost();
        }
        int i = pathInfo.lastIndexOf(47);
        String serviceName = i > -1 ? pathInfo.substring(i + 1) : pathInfo;
        return serviceName;
    }

    public String parseSoapAction(String soapAction, QName method, UMOEvent event) {
        UMOEndpointURI endpointURI = event.getEndpoint().getEndpointURI();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        UMOMessage msg = event.getMessage();
        Iterator iterator = msg.getPropertyNames().iterator();
        while (iterator.hasNext()) {
            String propertyKey = (String)iterator.next();
            properties.put(propertyKey, msg.getProperty(propertyKey));
        }
        properties.put("method", method.getLocalPart());
        properties.put("methodNamespace", method.getNamespaceURI());
        properties.put("address", endpointURI.getAddress());
        properties.put("scheme", endpointURI.getScheme());
        properties.put("host", endpointURI.getHost());
        properties.put("port", String.valueOf(endpointURI.getPort()));
        properties.put("path", endpointURI.getPath());
        properties.put("hostInfo", endpointURI.getScheme() + "://" + endpointURI.getHost() + (endpointURI.getPort() > -1 ? ":" + String.valueOf(endpointURI.getPort()) : ""));
        if (event.getComponent() != null) {
            properties.put("serviceName", event.getComponent().getDescriptor().getName());
        }
        TemplateParser tp = TemplateParser.createAntStyleParser();
        soapAction = tp.parse(properties, soapAction);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("SoapAction for this call is: " + soapAction));
        }
        return soapAction;
    }
}

