/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.xfire;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.invoker.Invoker;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.soap.xfire.MuleInvoker;
import org.mule.providers.soap.xfire.XFireConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.util.MapUtils;

public class XFireMessageReceiver
extends AbstractMessageReceiver {
    protected XFireConnector connector;
    protected Service service;

    public XFireMessageReceiver(UMOConnector umoConnector, UMOComponent component, UMOEndpoint umoEndpoint) throws InitialisationException {
        super(umoConnector, component, umoEndpoint);
        this.connector = (XFireConnector)umoConnector;
        this.init();
    }

    protected void init() throws InitialisationException {
        try {
            HashMap props = new HashMap(this.component.getDescriptor().getProperties());
            props.putAll(this.endpoint.getProperties());
            String namespace = MapUtils.getString(props, (Object)"namespace", (String)"http://www.muleumo.org");
            if (props.size() == 0) {
                props = null;
            } else {
                this.rewriteProperty(props, "portType");
                this.rewriteProperty(props, "style");
                this.rewriteProperty(props, "use");
                this.rewriteProperty(props, "createDefaultBindings");
                this.rewriteProperty(props, "soap12Transports");
                this.rewriteProperty(props, "soap11Transports");
                this.rewriteProperty(props, "scope");
                this.rewriteProperty(props, "schemas");
            }
            this.service = this.connector.getServiceFactory().create(this.component.getDescriptor().getImplementationClass(), this.component.getDescriptor().getName(), namespace, props);
            boolean sync = this.endpoint.isSynchronous();
            if (this.endpoint.getEndpointURI().getScheme().startsWith("http") || this.endpoint.getEndpointURI().getScheme().startsWith("servlet")) {
                sync = true;
            }
            this.service.setInvoker((Invoker)new MuleInvoker(this, sync));
        }
        catch (UMOException e) {
            throw new InitialisationException((Throwable)e, (Object)this);
        }
    }

    protected void rewriteProperty(Map props, String name) {
        Object temp = null;
        if (props.containsKey(name)) {
            temp = props.remove(name);
            props.put("objectServiceFactory." + name, temp);
        }
    }

    public void doConnect() throws Exception {
        this.connector.getXfire().getServiceRegistry().register(this.service);
        this.connector.registerReceiverWithMuleService((UMOMessageReceiver)this, this.endpoint.getEndpointURI());
    }

    public void doDisconnect() throws Exception {
        this.connector.getXfire().getServiceRegistry().unregister(this.service);
    }
}

