/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.xfire;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceRegistry;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.transport.http.HtmlServiceWriter;
import org.mule.MuleRuntimeException;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.UMODescriptorAware;
import org.mule.providers.soap.xfire.transport.MuleLocalChannel;
import org.mule.providers.soap.xfire.transport.MuleLocalTransport;
import org.mule.providers.streaming.OutStreamMessageAdapter;
import org.mule.providers.streaming.StreamMessageAdapter;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.lifecycle.Callable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.Lifecycle;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.umo.provider.UMOStreamMessageAdapter;
import org.mule.util.StringUtils;

public class XFireServiceComponent
implements Callable,
Initialisable,
Lifecycle,
UMODescriptorAware {
    public final String DEFAULT_CONTENT_TYPE = "text/html";
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected XFire xfire;
    protected Transport transport;

    public void setDescriptor(UMODescriptor descriptor) {
        UMOWorkManager wm = ((MuleDescriptor)descriptor).getThreadingProfile().createWorkManager("xfire-local-transport");
        try {
            wm.start();
        }
        catch (UMOException e) {
            throw new MuleRuntimeException(new Message(42, (Object)"local channel work manager", (Object)e));
        }
        this.transport = new MuleLocalTransport(wm);
        this.getTransportManager().register(this.transport);
    }

    public Object onCall(UMOEventContext eventContext) throws Exception {
        this.logger.debug((Object)eventContext);
        String request = eventContext.getMessage().getStringProperty("http.request", "");
        if (request.toLowerCase().endsWith("wsdl")) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.getXfire().generateWSDL(this.getServiceName(eventContext), (OutputStream)out);
            return out.toString();
        }
        MuleLocalChannel channel = (MuleLocalChannel)this.transport.createChannel(eventContext.getEndpointURI().getFullScheme());
        return channel.onCall(eventContext);
    }

    public void start() throws UMOException {
    }

    public void stop() throws UMOException {
    }

    public void initialise() throws InitialisationException {
        if (this.xfire == null) {
            throw new InitialisationException(new Message(45, (Object)"xfire"), (Object)this);
        }
    }

    public void dispose() {
    }

    protected TransportManager getTransportManager() {
        return this.getXfire().getTransportManager();
    }

    protected void generateService(OutStreamMessageAdapter response, String serviceName) throws IOException, XMLStreamException {
        response.setProperty("Content-Type", (Object)"text/html");
        Service endpoint = this.getServiceRegistry().getService(serviceName);
        HtmlServiceWriter writer = new HtmlServiceWriter();
        writer.write(response.getStream(), endpoint);
    }

    protected void generateServices(OutStreamMessageAdapter response) throws IOException, XMLStreamException {
        response.setProperty("Content-Type", (Object)"text/html");
        HtmlServiceWriter writer = new HtmlServiceWriter();
        writer.write(response.getStream(), this.getServiceRegistry().getServices());
    }

    protected InputStream getMessageStream(UMOEventContext context) throws UMOException {
        InputStream is;
        UMOMessage eventMsg = context.getMessage();
        Object eventMsgPayload = eventMsg.getPayload();
        if (eventMsgPayload instanceof InputStream) {
            is = (InputStream)eventMsgPayload;
        } else if (eventMsg.getAdapter() instanceof UMOStreamMessageAdapter) {
            StreamMessageAdapter sma = (StreamMessageAdapter)eventMsg.getAdapter();
            is = sma.getInputStream();
        } else {
            is = new ByteArrayInputStream(context.getTransformedMessageAsBytes());
        }
        return is;
    }

    protected String getServiceName(UMOEventContext context) {
        String pathInfo = context.getEndpointURI().getPath();
        if (StringUtils.isEmpty((String)pathInfo)) {
            return context.getEndpointURI().getHost();
        }
        int i = pathInfo.lastIndexOf("/");
        String serviceName = i > -1 ? pathInfo.substring(i + 1) : pathInfo;
        return serviceName;
    }

    protected Service getService(String name) {
        return this.getXfire().getServiceRegistry().getService(name);
    }

    public XFire getXfire() {
        return this.xfire;
    }

    public void setXfire(XFire xfire) {
        this.xfire = xfire;
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.xfire.getServiceRegistry();
    }
}

