/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.xfire.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.attachments.Attachment;
import org.codehaus.xfire.attachments.Attachments;
import org.codehaus.xfire.attachments.ByteDataSource;
import org.codehaus.xfire.attachments.JavaMailAttachments;
import org.codehaus.xfire.attachments.SimpleAttachment;
import org.codehaus.xfire.exchange.AbstractMessage;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.soap.Soap12;
import org.codehaus.xfire.soap.SoapVersion;
import org.codehaus.xfire.transport.AbstractChannel;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.util.STAXUtils;
import org.mule.MuleRuntimeException;
import org.mule.config.i18n.Message;
import org.mule.extras.client.MuleClient;
import org.mule.impl.RequestContext;
import org.mule.providers.soap.xfire.transport.MuleUniversalTransport;
import org.mule.providers.streaming.StreamMessageAdapter;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.provider.OutputHandler;
import org.mule.umo.provider.UMOStreamMessageAdapter;

public class MuleUniversalChannel
extends AbstractChannel {
    protected final transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected final transient MuleClient client;

    public MuleUniversalChannel(String uri, MuleUniversalTransport transport) {
        this.setTransport((Transport)transport);
        this.setUri(uri);
        try {
            this.client = new MuleClient();
        }
        catch (UMOException ex) {
            throw new MuleRuntimeException(new Message(40, (Object)"MuleClient"), (Throwable)ex);
        }
    }

    public void open() {
    }

    public void send(MessageContext context, OutMessage message) throws XFireException {
        if (message.getUri().equals("urn:xfire:channel:backchannel")) {
            OutputStream out = (OutputStream)context.getProperty("urn:xfire:channel:backchannel");
            if (out == null) {
                throw new XFireRuntimeException("No backchannel exists for message");
            }
            XMLStreamWriter writer = STAXUtils.createXMLStreamWriter((OutputStream)out, (String)message.getEncoding(), (MessageContext)context);
            message.getSerializer().writeMessage(message, writer, context);
            try {
                Attachments atts = message.getAttachments();
                if (atts != null && atts.size() > 0) {
                    this.writeAttachmentBody(context, message);
                    atts.write(out);
                }
                this.writeWithoutAttachments(context, message, out);
            }
            catch (IOException e) {
                throw new XFireException("Couldn't send message.", (Throwable)e);
            }
        } else {
            try {
                this.sendViaClient(context, message);
            }
            catch (Exception e) {
                throw new XFireException("Failed to Send via MuleUniversalChannel: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    void writeWithoutAttachments(MessageContext context, OutMessage message, OutputStream out) throws XFireException {
        XMLStreamWriter writer = STAXUtils.createXMLStreamWriter((OutputStream)out, (String)message.getEncoding(), (MessageContext)context);
        message.getSerializer().writeMessage(message, writer, context);
        try {
            writer.flush();
        }
        catch (XMLStreamException e) {
            this.logger.error((Object)e);
            throw new XFireException("Couldn't send message.", (Throwable)e);
        }
    }

    void writeAttachmentBody(MessageContext context, OutMessage message) throws XFireException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.writeWithoutAttachments(context, message, (OutputStream)bos);
        Attachments atts = message.getAttachments();
        ByteDataSource ds = new ByteDataSource(bos.toByteArray());
        ds.setContentType(MuleUniversalChannel.getSoapMimeType((AbstractMessage)message));
        DataHandler dh = new DataHandler((DataSource)ds);
        SimpleAttachment att = new SimpleAttachment("soap-message.xml", dh);
        atts.setSoapMessage((Attachment)att);
    }

    String getMimeType(AbstractMessage msg) {
        Attachments atts = msg.getAttachments();
        if (atts != null && atts.size() > 0) {
            return atts.getContentType();
        }
        return MuleUniversalChannel.getSoapMimeType(msg);
    }

    static String getSoapMimeType(AbstractMessage msg) {
        SoapVersion soap = msg.getSoapVersion();
        String encoding = msg.getEncoding();
        StringBuffer soapMimeType = new StringBuffer(40);
        if (soap instanceof Soap12) {
            soapMimeType.append("application/soap+xml; charset=");
        } else {
            soapMimeType.append("text/xml; charset=");
        }
        return soapMimeType.append(encoding).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendViaClient(final MessageContext context, final OutMessage message) throws Exception {
        OutputHandler handler = new OutputHandler(){

            public void write(UMOEvent event, OutputStream out) throws IOException {
                block5: {
                    try {
                        Attachments atts = message.getAttachments();
                        if (atts != null && atts.size() > 0) {
                            atts.write(out);
                            break block5;
                        }
                        XMLStreamWriter writer = STAXUtils.createXMLStreamWriter((OutputStream)out, (String)message.getEncoding(), (MessageContext)context);
                        message.getSerializer().writeMessage(message, writer, context);
                        try {
                            writer.flush();
                        }
                        catch (XMLStreamException e) {
                            MuleUniversalChannel.this.logger.error((Object)e);
                            throw new XFireException("Couldn't send message.", (Throwable)e);
                        }
                    }
                    catch (XFireException e) {
                        MuleUniversalChannel.this.logger.error((Object)"Couldn't send message.", (Throwable)e);
                        throw new IOException(e.getMessage());
                    }
                }
            }

            public Map getHeaders(UMOEvent event) {
                HashMap<String, Object> headers = new HashMap<String, Object>();
                headers.put("Content-Type", MuleUniversalChannel.getSoapMimeType((AbstractMessage)message));
                headers.put("SOAPAction", message.getProperty((Object)"SOAPAction"));
                UMOMessage msg = event.getMessage();
                Iterator iterator = msg.getPropertyNames().iterator();
                while (iterator.hasNext()) {
                    String headerName = (String)iterator.next();
                    String headerValue = msg.getStringProperty(headerName, null);
                    if (headerName.startsWith("MULE_") && "MULE_USER".compareTo(headerName) != 0 || "Content-Type".equalsIgnoreCase(headerName) || "Content-Length".equalsIgnoreCase(headerName)) continue;
                    headers.put(headerName, headerValue);
                }
                return headers;
            }
        };
        StreamMessageAdapter sp = new StreamMessageAdapter(handler);
        sp.setProperty("http.method", (Object)"POST");
        UMOMessage msg = RequestContext.getEvent().getMessage();
        Iterator i = msg.getPropertyNames().iterator();
        while (i.hasNext()) {
            String propertyName = (String)i.next();
            sp.setProperty(propertyName, msg.getProperty(propertyName));
        }
        UMOStreamMessageAdapter result = null;
        try {
            result = this.client.sendStream(this.getUri(), (UMOStreamMessageAdapter)sp);
            if (result != null) {
                InMessage inMessage;
                String contentType = sp.getStringProperty("Content-Type", "text/xml");
                InputStream in = result.getInputStream();
                if (contentType.toLowerCase().indexOf("multipart/related") != -1) {
                    try {
                        JavaMailAttachments atts = new JavaMailAttachments(in, contentType);
                        InputStream msgIs = atts.getSoapMessage().getDataHandler().getInputStream();
                        inMessage = new InMessage(STAXUtils.createXMLStreamReader((InputStream)msgIs, (String)message.getEncoding(), (MessageContext)context), this.getUri());
                        inMessage.setAttachments((Attachments)atts);
                    }
                    catch (MessagingException e) {
                        throw new IOException(e.getMessage());
                    }
                } else {
                    inMessage = new InMessage(STAXUtils.createXMLStreamReader((InputStream)in, (String)message.getEncoding(), (MessageContext)context), this.getUri());
                }
                this.getEndpoint().onReceive(context, inMessage);
            }
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            sp.release();
            if (result != null) {
                result.release();
            }
            throw throwable;
        }
        sp.release();
        if (result != null) {
            result.release();
        }
    }

    public void close() {
    }

    public boolean isAsync() {
        return false;
    }
}

