/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.xfire.transport;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.soap.SoapTransport;
import org.codehaus.xfire.soap.SoapTransportHelper;
import org.codehaus.xfire.transport.AbstractTransport;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.ChannelEndpoint;
import org.codehaus.xfire.transport.DefaultEndpoint;
import org.codehaus.xfire.transport.MapSession;
import org.codehaus.xfire.transport.Session;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.wsdl11.WSDL11Transport;
import org.mule.providers.soap.xfire.MuleInvoker;
import org.mule.providers.soap.xfire.transport.MuleLocalChannel;
import org.mule.umo.manager.UMOWorkManager;

public class MuleLocalTransport
extends AbstractTransport
implements SoapTransport,
WSDL11Transport {
    public static final String BINDING_ID = "urn:xfire:transport:local";
    public static final String URI_PREFIX = "xfire.local://";
    protected transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Session session;
    private boolean maintainSession;
    protected final UMOWorkManager workManager;

    public MuleLocalTransport(UMOWorkManager workManager) {
        SoapTransportHelper.createSoapTransport((AbstractTransport)this);
        this.workManager = workManager;
    }

    public String getServiceURL(Service service) {
        String ep = ((MuleInvoker)service.getInvoker()).getEndpoint().getEndpointURI().getAddress();
        return ep + "/" + service.getSimpleName();
    }

    protected Channel createNewChannel(String uri) {
        this.logger.debug((Object)("Creating new channel for uri: " + uri));
        MuleLocalChannel c = new MuleLocalChannel(uri, (Transport)this, this.session);
        c.setWorkManager(this.workManager);
        c.setEndpoint((ChannelEndpoint)new DefaultEndpoint());
        return c;
    }

    public void setMaintainSession(boolean maintainSession) {
        this.maintainSession = maintainSession;
        this.resetSession();
    }

    public void resetSession() {
        this.session = this.maintainSession ? new MapSession() : null;
    }

    protected String getUriPrefix() {
        return URI_PREFIX;
    }

    public String[] getSupportedBindings() {
        return new String[]{BINDING_ID};
    }

    public String[] getKnownUriSchemes() {
        return new String[]{URI_PREFIX};
    }

    public String getName() {
        return "Local";
    }

    public String[] getSoapTransportIds() {
        return new String[]{BINDING_ID};
    }
}

