/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.xfire;

import java.util.List;
import org.codehaus.xfire.DefaultXFire;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.aegis.type.TypeMappingRegistry;
import org.codehaus.xfire.annotations.AnnotationServiceFactory;
import org.codehaus.xfire.annotations.WebAnnotations;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceFactory;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.wsdl11.builder.WSDLBuilderFactory;
import org.mule.MuleManager;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.internal.notifications.ManagerNotificationListener;
import org.mule.impl.internal.notifications.NotificationException;
import org.mule.providers.AbstractConnector;
import org.mule.providers.soap.MethodFixInterceptor;
import org.mule.providers.soap.xfire.MuleObjectServiceFactory;
import org.mule.providers.soap.xfire.XFireServiceComponent;
import org.mule.providers.soap.xfire.i18n.XFireMessages;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOException;
import org.mule.umo.UMOInterceptor;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.manager.UMOServerNotificationListener;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;
import org.mule.util.SystemUtils;

public class XFireConnector
extends AbstractConnector
implements ManagerNotificationListener {
    public static final String XFIRE_SERVICE_COMPONENT_NAME = "_xfireServiceComponent";
    public static final String DEFAULT_MULE_NAMESPACE_URI = "http://www.muleumo.org";
    public static final String XFIRE_PROPERTY = "xfire";
    public static final String XFIRE_TRANSPORT = "transportClass";
    public static final String CLASSNAME_ANNOTATIONS = "org.codehaus.xfire.annotations.jsr181.Jsr181WebAnnotations";
    private static final String DEFAULT_BINDING_PROVIDER_CLASS = "org.codehaus.xfire.aegis.AegisBindingProvider";
    private static final String DEFAULT_TYPE_MAPPING_REGISTRY_CLASS = "org.codehaus.xfire.aegis.type.DefaultTypeMappingRegistry";
    protected MuleDescriptor xfireDescriptor;
    private XFire xfire;
    private ServiceFactory serviceFactory;
    private boolean enableJSR181Annotations = false;
    private List clientServices = null;
    private List clientInHandlers = null;
    private List clientOutHandlers = null;
    private String clientTransport = null;
    private String bindingProvider = null;
    private String typeMappingRegistry = null;
    private String serviceTransport = null;
    private List serverInHandlers = null;
    private List serverOutHandlers = null;

    public XFireConnector() {
        this.registerProtocols();
    }

    protected void registerProtocols() {
        this.registerSupportedProtocol("http");
        this.registerSupportedProtocol("https");
        this.registerSupportedProtocol("jms");
        this.registerSupportedProtocol("vm");
        this.registerSupportedProtocol("servlet");
    }

    public String getProtocol() {
        return XFIRE_PROPERTY;
    }

    protected void doInitialise() throws InitialisationException {
        ObjectServiceFactory osf;
        try {
            MuleManager.getInstance().registerListener((UMOServerNotificationListener)this);
        }
        catch (NotificationException e) {
            throw new InitialisationException((Throwable)e, (Object)this);
        }
        if (this.xfire == null) {
            this.xfire = new DefaultXFire();
        }
        if (this.clientServices != null) {
            ObjectServiceFactory factory = new ObjectServiceFactory();
            this.configureBindingProvider(factory);
            for (int i = 0; i < this.clientServices.size(); ++i) {
                try {
                    Class clazz = ClassUtils.loadClass((String)this.clientServices.get(i).toString(), ((Object)((Object)this)).getClass());
                    Service service = factory.create(clazz);
                    this.xfire.getServiceRegistry().register(service);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new InitialisationException(XFireMessages.couldNotInitAnnotationProcessor(this.clientServices.get(i)), (Throwable)e, (Object)this);
                }
            }
        }
        if (this.serviceFactory == null) {
            if (this.enableJSR181Annotations) {
                if (!SystemUtils.isJavaVersionAtLeast((int)150)) {
                    throw new InitialisationException(XFireMessages.annotationsRequireJava5(), (Object)this);
                }
                try {
                    WebAnnotations wa = (WebAnnotations)ClassUtils.instanciateClass((String)CLASSNAME_ANNOTATIONS, null, ((Object)((Object)this)).getClass());
                    this.serviceFactory = new AnnotationServiceFactory(wa, this.xfire.getTransportManager());
                    this.configureBindingProvider((ObjectServiceFactory)this.serviceFactory);
                }
                catch (Exception ex) {
                    throw new InitialisationException(XFireMessages.couldNotInitAnnotationProcessor(CLASSNAME_ANNOTATIONS), (Throwable)ex, (Object)this);
                }
            } else {
                this.serviceFactory = new MuleObjectServiceFactory(this.xfire.getTransportManager());
                this.configureBindingProvider((ObjectServiceFactory)this.serviceFactory);
            }
        }
        if (this.serviceFactory instanceof ObjectServiceFactory && (osf = (ObjectServiceFactory)this.serviceFactory).getTransportManager() == null) {
            osf.setTransportManager(this.xfire.getTransportManager());
        }
    }

    protected void configureBindingProvider(ObjectServiceFactory factory) throws InitialisationException {
        if (StringUtils.isBlank((String)this.bindingProvider)) {
            this.bindingProvider = DEFAULT_BINDING_PROVIDER_CLASS;
        }
        if (StringUtils.isBlank((String)this.typeMappingRegistry)) {
            this.typeMappingRegistry = DEFAULT_TYPE_MAPPING_REGISTRY_CLASS;
        }
        try {
            Class clazz = ClassUtils.loadClass((String)this.bindingProvider, ((Object)((Object)this)).getClass());
            BindingProvider provider = (BindingProvider)ClassUtils.instanciateClass((Class)clazz, (Object[])new Object[0]);
            if (this.bindingProvider.equals(DEFAULT_BINDING_PROVIDER_CLASS) && !this.typeMappingRegistry.equals(DEFAULT_TYPE_MAPPING_REGISTRY_CLASS)) {
                Class registryClazz = ClassUtils.loadClass((String)this.typeMappingRegistry, ((Object)((Object)this)).getClass());
                TypeMappingRegistry registry = (TypeMappingRegistry)ClassUtils.instanciateClass((Class)registryClazz, (Object[])new Object[0]);
                ((AegisBindingProvider)provider).setTypeMappingRegistry(registry);
            }
            factory.setBindingProvider(provider);
            String wsdlBuilderFactoryClass = null;
            if (this.bindingProvider.equals("org.codehaus.xfire.service.binding.MessageBindingProvider")) {
                factory.setStyle("message");
            }
            if (wsdlBuilderFactoryClass != null) {
                Class wsdlBuilderFactoryClazz = ClassUtils.loadClass(wsdlBuilderFactoryClass, ((Object)((Object)this)).getClass());
                WSDLBuilderFactory wsdlBuilderFactory = (WSDLBuilderFactory)ClassUtils.instanciateClass((Class)wsdlBuilderFactoryClazz, (Object[])new Object[0]);
                factory.setWsdlBuilderFactory(wsdlBuilderFactory);
            }
        }
        catch (Exception ex) {
            throw new InitialisationException(XFireMessages.unableToInitBindingProvider(this.bindingProvider), (Throwable)ex, (Object)this);
        }
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws UMOException {
    }

    protected void doStop() throws UMOException {
    }

    public XFire getXfire() {
        return this.xfire;
    }

    public void setXfire(XFire xfire) {
        this.xfire = xfire;
    }

    protected void registerReceiverWithMuleService(UMOMessageReceiver receiver, UMOEndpointURI ep) throws UMOException {
        if (this.xfireDescriptor == null) {
            this.xfireDescriptor = (MuleDescriptor)MuleManager.getInstance().lookupModel("_system").getDescriptor(XFIRE_SERVICE_COMPONENT_NAME + this.getName());
            if (this.xfireDescriptor == null) {
                this.xfireDescriptor = this.createxfireDescriptor();
            } else {
                MuleManager.getInstance().lookupModel("_system").unregisterComponent((UMODescriptor)this.xfireDescriptor);
            }
            if (this.xfireDescriptor.getProperties().get(XFIRE_PROPERTY) == null) {
                this.xfireDescriptor.getProperties().put(XFIRE_PROPERTY, this.xfire);
            }
            if (this.serviceTransport != null && this.xfireDescriptor.getProperties().get(XFIRE_TRANSPORT) == null) {
                this.xfireDescriptor.getProperties().put(XFIRE_TRANSPORT, this.serviceTransport);
            }
            this.xfireDescriptor.setContainerManaged(false);
        }
        String serviceName = receiver.getComponent().getDescriptor().getName();
        String endpoint = receiver.getEndpointURI().getAddress();
        String scheme = ep.getScheme().toLowerCase();
        boolean sync = receiver.getEndpoint().isSynchronous();
        if (scheme.equals("http") || scheme.equals("https") || scheme.equals("ssl") || scheme.equals("tcp") || scheme.equals("servlet")) {
            endpoint = endpoint + "/" + serviceName;
            receiver.getEndpoint().getProperties().put("http.method", "POST");
            receiver.getEndpoint().getProperties().put("Content-Type", "text/xml");
            if (!receiver.getEndpoint().isSynchronousSet()) {
                sync = true;
            }
        }
        MuleEndpoint serviceEndpoint = new MuleEndpoint(endpoint, true);
        serviceEndpoint.setSynchronous(sync);
        serviceEndpoint.setName(ep.getScheme() + ":" + serviceName);
        serviceEndpoint.setTransformer(receiver.getEndpoint().getTransformer());
        receiver.getEndpoint().setTransformer(null);
        serviceEndpoint.setResponseTransformer(receiver.getEndpoint().getResponseTransformer());
        receiver.getEndpoint().setResponseTransformer(null);
        serviceEndpoint.setFilter(receiver.getEndpoint().getFilter());
        receiver.getEndpoint().setFilter(null);
        serviceEndpoint.setSecurityFilter(receiver.getEndpoint().getSecurityFilter());
        receiver.getEndpoint().setSecurityFilter(null);
        this.xfireDescriptor.getInboundRouter().addEndpoint((UMOEndpoint)serviceEndpoint);
    }

    protected MuleDescriptor createxfireDescriptor() {
        MuleDescriptor xfireDescriptor = (MuleDescriptor)MuleManager.getInstance().lookupModel("_system").getDescriptor(XFIRE_SERVICE_COMPONENT_NAME + this.getName());
        if (xfireDescriptor == null) {
            xfireDescriptor = new MuleDescriptor(XFIRE_SERVICE_COMPONENT_NAME + this.getName());
            xfireDescriptor.setImplementation((Object)XFireServiceComponent.class.getName());
        }
        return xfireDescriptor;
    }

    public ServiceFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public void setServiceFactory(ServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    protected Object getReceiverKey(UMOComponent component, UMOEndpoint endpoint) {
        if (endpoint.getEndpointURI().getPort() == -1) {
            return component.getDescriptor().getName();
        }
        return endpoint.getEndpointURI().getAddress() + "/" + component.getDescriptor().getName();
    }

    public boolean isEnableJSR181Annotations() {
        return this.enableJSR181Annotations;
    }

    public void setEnableJSR181Annotations(boolean enableJSR181Annotations) {
        this.enableJSR181Annotations = enableJSR181Annotations;
    }

    public List getClientServices() {
        return this.clientServices;
    }

    public void setClientServices(List clientServices) {
        this.clientServices = clientServices;
    }

    public List getClientInHandlers() {
        return this.clientInHandlers;
    }

    public void setClientInHandlers(List handlers) {
        this.clientInHandlers = handlers;
    }

    public List getClientOutHandlers() {
        return this.clientOutHandlers;
    }

    public void setClientOutHandlers(List handlers) {
        this.clientOutHandlers = handlers;
    }

    public String getClientTransport() {
        return this.clientTransport;
    }

    public void setClientTransport(String transportClass) {
        this.clientTransport = transportClass;
    }

    public String getServiceTransport() {
        return this.serviceTransport;
    }

    public void setServiceTransport(String transportClass) {
        this.serviceTransport = transportClass;
    }

    public String getBindingProvider() {
        return this.bindingProvider;
    }

    public void setBindingProvider(String bindingProvider) {
        this.bindingProvider = bindingProvider;
    }

    public String getTypeMappingRegistry() {
        return this.typeMappingRegistry;
    }

    public void setTypeMappingRegistry(String typeMappingRegistry) {
        this.typeMappingRegistry = typeMappingRegistry;
    }

    public void onNotification(UMOServerNotification event) {
        if (event.getAction() == 112 && !MuleManager.getInstance().lookupModel("_system").isComponentRegistered(XFIRE_SERVICE_COMPONENT_NAME + this.getName())) {
            try {
                if (this.xfireDescriptor == null) {
                    this.xfireDescriptor = this.createxfireDescriptor();
                }
                this.xfireDescriptor.addInterceptor((UMOInterceptor)new MethodFixInterceptor());
                if (this.xfireDescriptor.getProperties().get(XFIRE_PROPERTY) == null) {
                    this.xfireDescriptor.getProperties().put(XFIRE_PROPERTY, this.xfire);
                }
                MuleManager.getInstance().lookupModel("_system").registerComponent((UMODescriptor)this.xfireDescriptor);
            }
            catch (UMOException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    public List getServerInHandlers() {
        return this.serverInHandlers;
    }

    public void setServerInHandlers(List serverInHandlers) {
        this.serverInHandlers = serverInHandlers;
    }

    public List getServerOutHandlers() {
        return this.serverOutHandlers;
    }

    public void setServerOutHandlers(List serverOutHandlers) {
        this.serverOutHandlers = serverOutHandlers;
    }
}

