/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.xfire;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.xfire.annotations.WebAnnotations;
import org.codehaus.xfire.annotations.WebServiceAnnotation;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.invoker.Invoker;
import org.mule.config.converters.QNameConverter;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.soap.xfire.MuleInvoker;
import org.mule.providers.soap.xfire.XFireConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.util.ClassUtils;
import org.mule.util.MapUtils;
import org.mule.util.StringUtils;

public class XFireMessageReceiver
extends AbstractMessageReceiver {
    private static final String PORT_TYPE = "portType";
    protected XFireConnector connector;
    protected Service service;
    protected List serviceInterfaces;

    public XFireMessageReceiver(UMOConnector umoConnector, UMOComponent component, UMOEndpoint umoEndpoint) throws InitialisationException {
        super(umoConnector, component, umoEndpoint);
        this.connector = (XFireConnector)umoConnector;
        this.init();
    }

    protected void init() throws InitialisationException {
        try {
            Class exposedInterface;
            HashMap<String, Serializable> props = new HashMap<String, Serializable>(this.component.getDescriptor().getProperties());
            props.putAll(this.endpoint.getProperties());
            if (props.containsKey(PORT_TYPE)) {
                Object value = props.get(PORT_TYPE);
                QNameConverter converter = new QNameConverter(true);
                QName portTypeQName = (QName)converter.convert(QName.class, value);
                props.put(PORT_TYPE, portTypeQName);
            }
            String namespace = (String)this.component.getDescriptor().getProperties().get("SOAP_NAMESPACE_PROPERTY");
            if (this.connector.isEnableJSR181Annotations()) {
                WebAnnotations wa = (WebAnnotations)ClassUtils.instanciateClass((String)"org.codehaus.xfire.annotations.jsr181.Jsr181WebAnnotations", null, ((Object)((Object)this)).getClass());
                WebServiceAnnotation webServiceAnnotation = wa.getWebServiceAnnotation(this.component.getDescriptor().getImplementationClass());
                namespace = webServiceAnnotation.getTargetNamespace();
            }
            if (namespace == null || namespace.equalsIgnoreCase("")) {
                namespace = MapUtils.getString(props, (Object)"namespace", (String)"http://www.muleumo.org");
            }
            if (props.get("createDefaultBindings") != null) {
                props.put("createDefaultBindings", Boolean.valueOf((String)props.get("createDefaultBindings")));
            }
            if (props.size() == 0) {
                props = null;
            } else {
                this.rewriteProperty(props, PORT_TYPE);
                this.rewriteProperty(props, "style");
                this.rewriteProperty(props, "use");
                this.rewriteProperty(props, "createDefaultBindings");
                this.rewriteProperty(props, "soap12Transports");
                this.rewriteProperty(props, "soap11Transports");
                this.rewriteProperty(props, "scope");
                this.rewriteProperty(props, "schemas");
            }
            this.serviceInterfaces = (List)this.component.getDescriptor().getProperties().get("serviceInterfaces");
            if (this.serviceInterfaces == null) {
                exposedInterface = this.component.getDescriptor().getImplementationClass();
            } else {
                String className = (String)this.serviceInterfaces.get(0);
                exposedInterface = ClassUtils.loadClass((String)className, ((Object)((Object)this)).getClass());
                this.logger.info((Object)(className + " class was used to expose your service"));
                if (this.serviceInterfaces.size() > 1) {
                    this.logger.info((Object)"Only the first class was used to expose your method");
                }
            }
            String wsdlUrl = (String)this.component.getDescriptor().getProperties().get("WSDL_URL");
            this.service = StringUtils.isBlank((String)wsdlUrl) ? this.connector.getServiceFactory().create(exposedInterface, this.component.getDescriptor().getName(), namespace, props) : this.connector.getServiceFactory().create(exposedInterface, new QName(namespace, this.component.getDescriptor().getName()), new URL(wsdlUrl), props);
            List inList = this.connector.getServerInHandlers();
            if (inList != null) {
                for (int i = 0; i < inList.size(); ++i) {
                    Class clazz = ClassUtils.loadClass((String)inList.get(i).toString(), ((Object)((Object)this)).getClass());
                    Handler handler = (Handler)clazz.getConstructor(null).newInstance(null);
                    this.service.addInHandler(handler);
                }
            }
            boolean sync = this.endpoint.isSynchronous();
            if (this.endpoint.getEndpointURI().getScheme().startsWith("http") || this.endpoint.getEndpointURI().getScheme().startsWith("servlet")) {
                sync = true;
            }
            this.service.setInvoker((Invoker)new MuleInvoker(this, sync));
        }
        catch (UMOException e) {
            throw new InitialisationException((Throwable)e, (Object)this);
        }
        catch (ClassNotFoundException e) {
            throw new InitialisationException((Throwable)e, (Object)this);
        }
        catch (MalformedURLException e) {
            throw new InitialisationException((Throwable)e, (Object)this);
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Object)this);
        }
    }

    protected void doDispose() {
    }

    public void doConnect() throws Exception {
        this.connector.getXfire().getServiceRegistry().register(this.service);
        this.connector.registerReceiverWithMuleService((UMOMessageReceiver)this, this.endpoint.getEndpointURI());
    }

    public void doDisconnect() throws Exception {
        this.connector.getXfire().getServiceRegistry().unregister(this.service);
    }

    public void doStart() throws UMOException {
    }

    public void doStop() throws UMOException {
    }

    protected void rewriteProperty(Map props, String name) {
        if (props.containsKey(name)) {
            Object temp = props.remove(name);
            props.put("objectServiceFactory." + name, temp);
        }
    }
}

