/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.xfire.wsdl;

import java.net.URL;
import javax.xml.namespace.QName;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.service.Service;
import org.mule.providers.soap.xfire.XFireMessageDispatcher;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.util.StringUtils;

public class XFireWsdlMessageDispatcher
extends XFireMessageDispatcher {
    public static final String DEFAULT_WSDL_TRANSPORT = "org.codehaus.xfire.transport.http.SoapHttpTransport";

    public XFireWsdlMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
    }

    protected void doConnect() throws Exception {
        try {
            Service service;
            XFire xfire = this.connector.getXfire();
            String wsdlUrl = this.endpoint.getEndpointURI().getAddress();
            String serviceName = this.endpoint.getEndpointURI().getAddress();
            if (this.endpoint.getProperty((Object)"wsdlUrl") != null && StringUtils.isNotBlank((String)this.endpoint.getProperty((Object)"wsdlUrl").toString())) {
                wsdlUrl = (String)this.endpoint.getProperty((Object)"wsdlUrl");
            }
            if (serviceName.indexOf("?") > -1) {
                serviceName = serviceName.substring(0, serviceName.lastIndexOf(63));
            }
            if ((service = xfire.getServiceRegistry().getService(new QName(serviceName))) == null) {
                service = new Client(new URL(wsdlUrl)).getService();
                service.setName(new QName(serviceName));
                xfire.getServiceRegistry().register(service);
            }
            try {
                this.client = this.createXFireWsdlClient(this.endpoint, service, xfire, wsdlUrl);
            }
            catch (Exception ex) {
                this.disconnect();
                throw ex;
            }
        }
        catch (Exception ex) {
            this.disconnect();
            throw ex;
        }
    }

    protected Client createXFireWsdlClient(UMOImmutableEndpoint endpoint, Service service, XFire xfire, String wsdlUrl) throws Exception {
        UMOEndpointURI uri = endpoint.getEndpointURI();
        Client client = new Client(new URL(wsdlUrl));
        client.setXFire(xfire);
        client.setEndpointUri(uri.toString());
        return this.configureXFireClient(client);
    }
}

