/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.xfire;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.xfire.DefaultXFire;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.aegis.type.TypeMappingRegistry;
import org.codehaus.xfire.annotations.AnnotationServiceFactory;
import org.codehaus.xfire.annotations.WebAnnotations;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceFactory;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.wsdl11.builder.WSDLBuilderFactory;
import org.mule.MuleRuntimeException;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.endpoint.EndpointURIEndpointBuilder;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.internal.notifications.ManagerNotificationListener;
import org.mule.impl.internal.notifications.NotificationException;
import org.mule.impl.model.seda.SedaComponent;
import org.mule.providers.AbstractConnector;
import org.mule.providers.soap.xfire.MuleObjectServiceFactory;
import org.mule.providers.soap.xfire.XFireMessageReceiver;
import org.mule.providers.soap.xfire.XFireServiceComponent;
import org.mule.providers.soap.xfire.i18n.XFireMessages;
import org.mule.providers.soap.xfire.transport.MuleLocalTransport;
import org.mule.providers.soap.xfire.transport.MuleUniversalTransport;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpointBuilder;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.manager.UMOServerNotificationListener;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;
import org.mule.util.SystemUtils;
import org.mule.util.object.ObjectFactory;
import org.mule.util.object.SingletonObjectFactory;

public class XFireConnector
extends AbstractConnector
implements ManagerNotificationListener {
    public static final String XFIRE_SERVICE_COMPONENT_NAME = "_xfireServiceComponent";
    public static final String DEFAULT_MULE_NAMESPACE_URI = "http://www.muleumo.org";
    public static final String XFIRE_PROPERTY = "xfire";
    public static final String XFIRE_TRANSPORT = "transportClass";
    public static final String CLASSNAME_ANNOTATIONS = "org.codehaus.xfire.annotations.jsr181.Jsr181WebAnnotations";
    private static final String DEFAULT_BINDING_PROVIDER_CLASS = "org.codehaus.xfire.aegis.AegisBindingProvider";
    private static final String DEFAULT_TYPE_MAPPING_muleRegistry_CLASS = "org.codehaus.xfire.aegis.type.DefaultTypeMappingRegistry";
    private XFire xfire;
    private ServiceFactory serviceFactory;
    private boolean enableJSR181Annotations = false;
    private List components = new ArrayList();
    private List clientServices = null;
    private List clientInHandlers = null;
    private List clientOutHandlers = null;
    private String clientTransport = null;
    private String bindingProvider = null;
    private String typeMappingRegistry = null;
    private String serviceTransport = null;
    private List serverInHandlers = null;
    private List serverOutHandlers = null;
    private MuleUniversalTransport universalTransport;
    private Transport transport;
    private String transportClass;

    public XFireConnector() {
        this.registerProtocols();
        this.setEnableMessageEvents(true);
    }

    protected void registerProtocols() {
        this.registerSupportedProtocol("http");
        this.registerSupportedProtocol("https");
        this.registerSupportedProtocol("jms");
        this.registerSupportedProtocol("vm");
        this.registerSupportedProtocol("servlet");
    }

    public String getProtocol() {
        return XFIRE_PROPERTY;
    }

    protected void doInitialise() throws InitialisationException {
        ObjectServiceFactory osf;
        try {
            this.managementContext.registerListener((UMOServerNotificationListener)this);
        }
        catch (NotificationException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        if (this.xfire == null) {
            this.xfire = new DefaultXFire();
        }
        if (this.clientServices != null) {
            ObjectServiceFactory factory = new ObjectServiceFactory();
            this.configureBindingProvider(factory);
            for (int i = 0; i < this.clientServices.size(); ++i) {
                try {
                    Class clazz = ClassUtils.loadClass((String)this.clientServices.get(i).toString(), ((Object)((Object)this)).getClass());
                    Service service = factory.create(clazz);
                    this.xfire.getServiceRegistry().register(service);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new InitialisationException(XFireMessages.couldNotInitAnnotationProcessor(this.clientServices.get(i)), (Throwable)e, (Initialisable)this);
                }
            }
        }
        if (this.serviceFactory == null) {
            if (this.enableJSR181Annotations) {
                if (!SystemUtils.isJavaVersionAtLeast((int)150)) {
                    throw new InitialisationException(XFireMessages.annotationsRequireJava5(), (Initialisable)this);
                }
                try {
                    WebAnnotations wa = (WebAnnotations)ClassUtils.instanciateClass((String)CLASSNAME_ANNOTATIONS, null, ((Object)((Object)this)).getClass());
                    this.serviceFactory = new AnnotationServiceFactory(wa, this.xfire.getTransportManager());
                    this.configureBindingProvider((ObjectServiceFactory)this.serviceFactory);
                }
                catch (Exception ex) {
                    throw new InitialisationException(XFireMessages.couldNotInitAnnotationProcessor(CLASSNAME_ANNOTATIONS), (Throwable)ex, (Initialisable)this);
                }
            } else {
                this.serviceFactory = new MuleObjectServiceFactory(this.xfire.getTransportManager());
                this.configureBindingProvider((ObjectServiceFactory)this.serviceFactory);
            }
        }
        if (this.serviceFactory instanceof ObjectServiceFactory && (osf = (ObjectServiceFactory)this.serviceFactory).getTransportManager() == null) {
            osf.setTransportManager(this.xfire.getTransportManager());
        }
        UMOWorkManager wm = this.getReceiverThreadingProfile().createWorkManager("xfire-local-transport");
        try {
            wm.start();
        }
        catch (UMOException e) {
            throw new MuleRuntimeException(CoreMessages.failedToStart((String)"local channel work manager"), (Throwable)e);
        }
        this.createLocalTransport(wm);
        this.xfire.getTransportManager().register(this.transport);
        this.universalTransport = new MuleUniversalTransport();
        this.xfire.getTransportManager().register((Transport)this.universalTransport);
    }

    protected void createLocalTransport(UMOWorkManager wm) {
        if (this.transportClass == null) {
            this.transport = new MuleLocalTransport(wm);
        } else {
            try {
                Constructor constructor;
                Class transportClazz;
                block7: {
                    transportClazz = ClassUtils.loadClass((String)this.transportClass, ((Object)((Object)this)).getClass());
                    try {
                        constructor = transportClazz.getConstructor(UMOWorkManager.class);
                        this.transport = (Transport)constructor.newInstance(wm);
                    }
                    catch (NoSuchMethodException ne) {
                        if (!this.logger.isDebugEnabled()) break block7;
                        this.logger.debug((Object)ne.getCause());
                    }
                }
                if (this.transport == null) {
                    constructor = transportClazz.getConstructor(null);
                    this.transport = (Transport)constructor.newInstance(null);
                }
            }
            catch (Exception e) {
                throw new MuleRuntimeException(CoreMessages.failedToLoad((String)"xfire service transport"), (Throwable)e);
            }
        }
    }

    protected void configureBindingProvider(ObjectServiceFactory factory) throws InitialisationException {
        if (StringUtils.isBlank((String)this.bindingProvider)) {
            this.bindingProvider = DEFAULT_BINDING_PROVIDER_CLASS;
        }
        if (StringUtils.isBlank((String)this.typeMappingRegistry)) {
            this.typeMappingRegistry = DEFAULT_TYPE_MAPPING_muleRegistry_CLASS;
        }
        try {
            Class clazz = ClassUtils.loadClass((String)this.bindingProvider, ((Object)((Object)this)).getClass());
            BindingProvider provider = (BindingProvider)ClassUtils.instanciateClass((Class)clazz, (Object[])new Object[0]);
            if (this.bindingProvider.equals(DEFAULT_BINDING_PROVIDER_CLASS) && !this.typeMappingRegistry.equals(DEFAULT_TYPE_MAPPING_muleRegistry_CLASS)) {
                Class registryClazz = ClassUtils.loadClass((String)this.typeMappingRegistry, ((Object)((Object)this)).getClass());
                TypeMappingRegistry registry = (TypeMappingRegistry)ClassUtils.instanciateClass((Class)registryClazz, (Object[])new Object[0]);
                ((AegisBindingProvider)provider).setTypeMappingRegistry(registry);
            }
            factory.setBindingProvider(provider);
            String wsdlBuilderFactoryClass = null;
            if (this.bindingProvider.equals("org.codehaus.xfire.service.binding.MessageBindingProvider")) {
                factory.setStyle("message");
            }
            if (wsdlBuilderFactoryClass != null) {
                Class wsdlBuilderFactoryClazz = ClassUtils.loadClass(wsdlBuilderFactoryClass, ((Object)((Object)this)).getClass());
                WSDLBuilderFactory wsdlBuilderFactory = (WSDLBuilderFactory)ClassUtils.instanciateClass((Class)wsdlBuilderFactoryClazz, (Object[])new Object[0]);
                factory.setWsdlBuilderFactory(wsdlBuilderFactory);
            }
        }
        catch (Exception ex) {
            throw new InitialisationException(XFireMessages.unableToInitBindingProvider(this.bindingProvider), (Throwable)ex, (Initialisable)this);
        }
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws UMOException {
    }

    protected void doStop() throws UMOException {
    }

    public XFire getXfire() {
        return this.xfire;
    }

    public void setXfire(XFire xfire) {
        this.xfire = xfire;
    }

    protected void registerReceiverWithMuleService(UMOMessageReceiver receiver, UMOEndpointURI ep) throws UMOException {
        SedaComponent c = new SedaComponent();
        c.setName(XFIRE_SERVICE_COMPONENT_NAME + receiver.getComponent().getName());
        c.setModel(this.managementContext.getRegistry().lookupSystemModel());
        c.setManagementContext(this.managementContext);
        c.initialise();
        XFireServiceComponent svcComponent = new XFireServiceComponent((XFireMessageReceiver)receiver);
        svcComponent.setXfire(this.xfire);
        svcComponent.setTransport(this.transport);
        svcComponent.initialise();
        SingletonObjectFactory of = new SingletonObjectFactory((Object)svcComponent);
        of.setComponent((UMOComponent)c);
        of.initialise();
        c.setServiceFactory((ObjectFactory)of);
        if (c.getProperties().get(XFIRE_PROPERTY) == null) {
            c.getProperties().put(XFIRE_PROPERTY, this.xfire);
        }
        if (this.serviceTransport != null && c.getProperties().get(XFIRE_TRANSPORT) == null) {
            c.getProperties().put(XFIRE_TRANSPORT, this.serviceTransport);
        }
        String serviceName = receiver.getComponent().getName();
        String endpoint = receiver.getEndpointURI().getAddress();
        String scheme = ep.getScheme().toLowerCase();
        boolean sync = receiver.getEndpoint().isSynchronous();
        if (scheme.equals("http") || scheme.equals("https") || scheme.equals("ssl") || scheme.equals("tcp") || scheme.equals("servlet")) {
            endpoint = endpoint + "/" + serviceName;
            receiver.getEndpoint().getProperties().put("http.method", "POST");
            receiver.getEndpoint().getProperties().put("Content-Type", "text/xml");
            if (!receiver.getEndpoint().isSynchronousSet()) {
                sync = true;
            }
        }
        EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder(endpoint, this.managementContext);
        builder.setSynchronous(sync);
        builder.setName(ep.getScheme() + ":" + serviceName);
        builder.setTransformers(receiver.getEndpoint().getTransformers());
        ((MuleEndpoint)receiver.getEndpoint()).setTransformers(new LinkedList());
        builder.setResponseTransformers(receiver.getEndpoint().getResponseTransformers());
        ((MuleEndpoint)receiver.getEndpoint()).setResponseTransformers(new LinkedList());
        builder.setFilter(receiver.getEndpoint().getFilter());
        ((MuleEndpoint)receiver.getEndpoint()).setFilter(null);
        builder.setSecurityFilter(receiver.getEndpoint().getSecurityFilter());
        ((MuleEndpoint)receiver.getEndpoint()).setSecurityFilter(null);
        UMOImmutableEndpoint serviceEndpoint = this.managementContext.getRegistry().lookupEndpointFactory().createInboundEndpoint((UMOEndpointBuilder)builder, this.managementContext);
        c.getInboundRouter().addEndpoint(serviceEndpoint);
        this.components.add(c);
    }

    public ServiceFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public void setServiceFactory(ServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    protected Object getReceiverKey(UMOComponent component, UMOImmutableEndpoint endpoint) {
        if (endpoint.getEndpointURI().getPort() == -1) {
            return component.getName();
        }
        return endpoint.getEndpointURI().getAddress() + "/" + component.getName();
    }

    public boolean isEnableJSR181Annotations() {
        return this.enableJSR181Annotations;
    }

    public void setEnableJSR181Annotations(boolean enableJSR181Annotations) {
        this.enableJSR181Annotations = enableJSR181Annotations;
    }

    public List getClientServices() {
        return this.clientServices;
    }

    public void setClientServices(List clientServices) {
        this.clientServices = clientServices;
    }

    public List getClientInHandlers() {
        return this.clientInHandlers;
    }

    public void setClientInHandlers(List handlers) {
        this.clientInHandlers = handlers;
    }

    public List getClientOutHandlers() {
        return this.clientOutHandlers;
    }

    public void setClientOutHandlers(List handlers) {
        this.clientOutHandlers = handlers;
    }

    public String getClientTransport() {
        return this.clientTransport;
    }

    public void setClientTransport(String transportClass) {
        this.clientTransport = transportClass;
    }

    public String getServiceTransport() {
        return this.serviceTransport;
    }

    public void setServiceTransport(String transportClass) {
        this.serviceTransport = transportClass;
    }

    public String getBindingProvider() {
        return this.bindingProvider;
    }

    public void setBindingProvider(String bindingProvider) {
        this.bindingProvider = bindingProvider;
    }

    public String getTypeMappingRegistry() {
        return this.typeMappingRegistry;
    }

    public void setTypeMappingRegistry(String typeMappingRegistry) {
        this.typeMappingRegistry = typeMappingRegistry;
    }

    public void onNotification(UMOServerNotification event) {
        if (event.getAction() == 104) {
            Iterator itr = this.components.iterator();
            while (itr.hasNext()) {
                UMOComponent c = (UMOComponent)itr.next();
                try {
                    this.managementContext.getRegistry().registerComponent(c, this.managementContext);
                    c.start();
                }
                catch (UMOException e) {
                    this.handleException((Exception)((Object)e));
                }
            }
        }
    }

    public List getServerInHandlers() {
        return this.serverInHandlers;
    }

    public void setServerInHandlers(List serverInHandlers) {
        this.serverInHandlers = serverInHandlers;
    }

    public List getServerOutHandlers() {
        return this.serverOutHandlers;
    }

    public void setServerOutHandlers(List serverOutHandlers) {
        this.serverOutHandlers = serverOutHandlers;
    }

    public void setTransportClass(String clazz) {
        this.transportClass = clazz;
    }
}

