/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.xfire;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.TypeMapping;
import org.codehaus.xfire.aegis.type.basic.BeanType;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.Transport;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.FatalConnectException;
import org.mule.providers.soap.i18n.SoapMessages;
import org.mule.providers.soap.xfire.MuleHeadersInHandler;
import org.mule.providers.soap.xfire.MuleHeadersOutHandler;
import org.mule.providers.soap.xfire.XFireConnector;
import org.mule.providers.soap.xfire.i18n.XFireMessages;
import org.mule.providers.soap.xfire.transport.MuleUniversalTransport;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.UMOConnectable;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.transformer.TransformerException;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;
import org.mule.util.TemplateParser;

public class XFireMessageDispatcher
extends AbstractMessageDispatcher {
    protected Client client = null;
    protected final XFireConnector connector;
    private final TemplateParser soapActionTemplateParser = TemplateParser.createAntStyleParser();

    public XFireMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (XFireConnector)endpoint.getConnector();
    }

    protected void doConnect() throws Exception {
        if (this.client == null) {
            List outList;
            XFire xfire = this.connector.getXfire();
            String serviceName = this.getServiceName(this.endpoint);
            Service service = xfire.getServiceRegistry().getService(serviceName);
            if (service == null) {
                throw new FatalConnectException(XFireMessages.serviceIsNull(serviceName), (UMOConnectable)this);
            }
            List inList = this.connector.getServerInHandlers();
            if (inList != null) {
                for (int i = 0; i < inList.size(); ++i) {
                    Handler handler = (Handler)ClassUtils.instanciateClass((String)inList.get(i).toString(), (Object[])ClassUtils.NO_ARGS, ((Object)((Object)this)).getClass());
                    service.addInHandler(handler);
                }
            }
            if ((outList = this.connector.getServerOutHandlers()) != null) {
                for (int i = 0; i < outList.size(); ++i) {
                    Handler handler = (Handler)ClassUtils.instanciateClass((String)outList.get(i).toString(), (Object[])ClassUtils.NO_ARGS, ((Object)((Object)this)).getClass());
                    service.addOutHandler(handler);
                }
            }
            try {
                this.client = this.createXFireClient(this.endpoint, service, xfire);
            }
            catch (Exception ex) {
                this.disconnect();
                throw ex;
            }
        }
    }

    protected Client createXFireClient(UMOImmutableEndpoint endpoint, Service service, XFire xfire) throws Exception {
        return this.createXFireClient(endpoint, service, xfire, null);
    }

    protected Client createXFireClient(UMOImmutableEndpoint endpoint, Service service, XFire xfire, String transportClass) throws Exception {
        Class transportClazz;
        Class clazz = transportClazz = MuleUniversalTransport.class;
        if (this.connector.getClientTransport() == null) {
            if (!StringUtils.isBlank((String)transportClass)) {
                transportClazz = ClassUtils.loadClass((String)transportClass, ((Object)((Object)this)).getClass());
            }
        } else {
            transportClazz = ClassUtils.loadClass((String)this.connector.getClientTransport(), ((Object)((Object)this)).getClass());
        }
        Transport transport = (Transport)transportClazz.getConstructor(null).newInstance(null);
        Client client = new Client(transport, service, endpoint.getEndpointURI().toString());
        client.setXFire(xfire);
        client.setEndpointUri(endpoint.getEndpointURI().toString());
        return this.configureXFireClient(client);
    }

    protected Client configureXFireClient(Client client) throws Exception {
        List outList;
        client.addInHandler((Handler)new MuleHeadersInHandler());
        client.addOutHandler((Handler)new MuleHeadersOutHandler());
        List inList = this.connector.getClientInHandlers();
        if (inList != null) {
            for (int i = 0; i < inList.size(); ++i) {
                Class clazz = ClassUtils.loadClass((String)inList.get(i).toString(), ((Object)((Object)this)).getClass());
                Handler handler = (Handler)clazz.getConstructor(null).newInstance(null);
                client.addInHandler(handler);
            }
        }
        if ((outList = this.connector.getClientOutHandlers()) != null) {
            for (int i = 0; i < outList.size(); ++i) {
                Class clazz = ClassUtils.loadClass((String)outList.get(i).toString(), ((Object)((Object)this)).getClass());
                Handler handler = (Handler)clazz.getConstructor(null).newInstance(null);
                client.addOutHandler(handler);
            }
        }
        return client;
    }

    protected void doDisconnect() throws Exception {
        this.client = null;
    }

    protected void doDispose() {
    }

    protected String getMethod(UMOEvent event) throws DispatchException {
        String method = (String)event.getMessage().getProperty("method");
        if (method == null) {
            UMOEndpointURI endpointUri = event.getEndpoint().getEndpointURI();
            method = (String)endpointUri.getParams().get("method");
        }
        if (method == null) {
            method = (String)event.getEndpoint().getProperties().get("method");
        }
        if (method == null) {
            throw new DispatchException(SoapMessages.cannotInvokeCallWithoutOperation(), event.getMessage(), event.getEndpoint());
        }
        return method;
    }

    protected Object[] getArgs(UMOEvent event) throws TransformerException {
        Object payload = event.getTransformedMessage();
        Object[] args = payload instanceof Object[] ? (Object[])payload : new Object[]{payload};
        UMOMessage message = event.getMessage();
        Set attachmentNames = message.getAttachmentNames();
        if (attachmentNames != null && !attachmentNames.isEmpty()) {
            ArrayList<DataHandler> attachments = new ArrayList<DataHandler>();
            Iterator i = attachmentNames.iterator();
            while (i.hasNext()) {
                attachments.add(message.getAttachment((String)i.next()));
            }
            ArrayList<Object> temp = new ArrayList<Object>(Arrays.asList(args));
            temp.add(attachments.toArray(new DataHandler[0]));
            args = temp.toArray();
        }
        return args;
    }

    protected UMOMessage doSend(UMOEvent event) throws Exception {
        if (event.getEndpoint().getProperty((Object)"complexTypes") != null) {
            this.configureClientForComplexTypes(this.client, event);
        }
        this.client.setTimeout(event.getTimeout());
        this.client.setProperty("MULE_EVENT", (Object)event);
        String method = this.getMethod(event);
        String soapAction = (String)event.getMessage().getProperty("soapAction");
        if (soapAction != null) {
            soapAction = this.parseSoapAction(soapAction, new QName(method), event);
            this.client.setProperty("SOAPAction", (Object)soapAction);
        }
        Object[] arr = event.getMessage().getPropertyNames().toArray();
        for (int i = 0; i < arr.length; ++i) {
            String head = "";
            head = (String)arr[i];
            if (head == null || head.startsWith("MULE")) continue;
            this.client.setProperty((String)arr[i], event.getMessage().getProperty((String)arr[i]));
        }
        Object[] response = this.client.invoke(method, this.getArgs(event));
        MuleMessage result = null;
        if (response != null && response.length <= 1) {
            if (response.length == 1) {
                result = new MuleMessage(response[0], (UMOMessageAdapter)event.getMessage());
            }
        } else {
            result = new MuleMessage((Object)response, (UMOMessageAdapter)event.getMessage());
        }
        return result;
    }

    protected void doDispatch(UMOEvent event) throws Exception {
        this.client.setTimeout(event.getTimeout());
        this.client.setProperty("MULE_EVENT", (Object)event);
        this.client.invoke(this.getMethod(event), this.getArgs(event));
    }

    protected UMOMessage doReceive(long timeout) throws Exception {
        String serviceName = this.getServiceName(this.endpoint);
        XFire xfire = this.connector.getXfire();
        Service service = xfire.getServiceRegistry().getService(serviceName);
        Client client = new Client((Transport)new MuleUniversalTransport(), service, this.endpoint.getEndpointURI().toString());
        client.setXFire(xfire);
        client.setTimeout((int)timeout);
        client.setEndpointUri(this.endpoint.getEndpointURI().toString());
        String method = (String)this.endpoint.getProperty((Object)"method");
        OperationInfo op = service.getServiceInfo().getOperation(method);
        Properties params = this.endpoint.getEndpointURI().getUserParams();
        Object[] args = new String[params.size()];
        int i = 0;
        Iterator<Object> iterator = params.values().iterator();
        while (iterator.hasNext()) {
            args[i] = iterator.next().toString();
            ++i;
        }
        Object[] response = client.invoke(op, args);
        if (response != null && response.length == 1) {
            return new MuleMessage(response[0]);
        }
        return new MuleMessage((Object)response);
    }

    protected String getServiceName(UMOImmutableEndpoint endpoint) {
        String pathInfo = endpoint.getEndpointURI().getPath();
        if (StringUtils.isEmpty((String)pathInfo)) {
            return endpoint.getEndpointURI().getHost();
        }
        int i = pathInfo.lastIndexOf(47);
        String serviceName = i > -1 ? pathInfo.substring(i + 1) : pathInfo;
        return serviceName;
    }

    public String parseSoapAction(String soapAction, QName method, UMOEvent event) {
        UMOEndpointURI endpointURI = event.getEndpoint().getEndpointURI();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        UMOMessage msg = event.getMessage();
        Iterator iterator = msg.getPropertyNames().iterator();
        while (iterator.hasNext()) {
            String propertyKey = (String)iterator.next();
            properties.put(propertyKey, msg.getProperty(propertyKey));
        }
        properties.put("method", method.getLocalPart());
        properties.put("methodNamespace", method.getNamespaceURI());
        properties.put("address", endpointURI.getAddress());
        properties.put("scheme", endpointURI.getScheme());
        properties.put("host", endpointURI.getHost());
        properties.put("port", String.valueOf(endpointURI.getPort()));
        properties.put("path", endpointURI.getPath());
        properties.put("hostInfo", endpointURI.getScheme() + "://" + endpointURI.getHost() + (endpointURI.getPort() > -1 ? ":" + String.valueOf(endpointURI.getPort()) : ""));
        if (event.getComponent() != null) {
            properties.put("serviceName", event.getComponent().getName());
        }
        soapAction = this.soapActionTemplateParser.parse(properties, soapAction);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("SoapAction for this call is: " + soapAction));
        }
        return soapAction;
    }

    protected void configureClientForComplexTypes(Client client, UMOEvent event) throws ClassNotFoundException {
        Map complexTypes = (Map)event.getEndpoint().getProperty((Object)"complexTypes");
        Object[] beans = complexTypes.keySet().toArray();
        AegisBindingProvider bp = (AegisBindingProvider)client.getService().getBindingProvider();
        TypeMapping typeMapping = bp.getTypeMapping(client.getService());
        for (int i = 0; i < beans.length; ++i) {
            BeanType bt = new BeanType();
            String[] queue = ((String)complexTypes.get(beans[i])).split(":", 2);
            bt.setSchemaType(new QName(queue[1], queue[0]));
            bt.setTypeClass(Class.forName(beans[i].toString()));
            typeMapping.register((Type)bt);
        }
    }
}

