/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.xfire;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.xfire.annotations.WebAnnotations;
import org.codehaus.xfire.annotations.WebServiceAnnotation;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.invoker.Invoker;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.soap.xfire.MuleInvoker;
import org.mule.providers.soap.xfire.XFireConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.CreateException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.util.ClassUtils;
import org.mule.util.MapUtils;
import org.mule.util.StringUtils;
import org.mule.util.object.SimpleObjectFactory;

public class XFireMessageReceiver
extends AbstractMessageReceiver {
    protected XFireConnector connector;
    protected Service service;
    protected List serviceInterfaces;

    public XFireMessageReceiver(UMOConnector umoConnector, UMOComponent component, UMOEndpoint umoEndpoint) throws CreateException {
        super(umoConnector, component, (UMOImmutableEndpoint)umoEndpoint);
        this.connector = (XFireConnector)umoConnector;
        this.create();
    }

    protected void create() throws CreateException {
        try {
            Class exposedInterface;
            HashMap<String, Boolean> props = new HashMap<String, Boolean>(this.component.getProperties());
            props.putAll(this.endpoint.getProperties());
            String namespace = (String)this.component.getProperties().get("SOAP_NAMESPACE_PROPERTY");
            if (this.connector.isEnableJSR181Annotations()) {
                WebAnnotations wa = (WebAnnotations)ClassUtils.instanciateClass((String)"org.codehaus.xfire.annotations.jsr181.Jsr181WebAnnotations", null, ((Object)((Object)this)).getClass());
                WebServiceAnnotation webServiceAnnotation = wa.getWebServiceAnnotation(Class.forName(((SimpleObjectFactory)this.component.getServiceFactory()).getObjectClassName()));
                namespace = webServiceAnnotation.getTargetNamespace();
            }
            if (namespace == null || namespace.equalsIgnoreCase("")) {
                namespace = MapUtils.getString(props, (Object)"namespace", (String)"http://www.muleumo.org");
            }
            if (props.get("createDefaultBindings") != null) {
                props.put("createDefaultBindings", Boolean.valueOf((String)props.get("createDefaultBindings")));
            }
            if (props.size() == 0) {
                props = null;
            } else {
                this.rewriteProperty(props, "portType");
                this.rewriteProperty(props, "style");
                this.rewriteProperty(props, "use");
                this.rewriteProperty(props, "createDefaultBindings");
                this.rewriteProperty(props, "soap12Transports");
                this.rewriteProperty(props, "soap11Transports");
                this.rewriteProperty(props, "scope");
                this.rewriteProperty(props, "schemas");
            }
            this.serviceInterfaces = (List)this.component.getProperties().get("serviceInterfaces");
            if (this.serviceInterfaces == null) {
                exposedInterface = this.component.getServiceFactory().getOrCreate().getClass();
            } else {
                String className = (String)this.serviceInterfaces.get(0);
                exposedInterface = ClassUtils.loadClass((String)className, ((Object)((Object)this)).getClass());
                this.logger.info((Object)(className + " class was used to expose your service"));
                if (this.serviceInterfaces.size() > 1) {
                    this.logger.info((Object)"Only the first class was used to expose your method");
                }
            }
            String wsdlUrl = (String)this.component.getProperties().get("WSDL_URL");
            this.service = StringUtils.isBlank((String)wsdlUrl) ? this.connector.getServiceFactory().create(exposedInterface, this.component.getName(), namespace, props) : this.connector.getServiceFactory().create(exposedInterface, new QName(namespace, this.component.getName()), new URL(wsdlUrl), props);
            List inList = this.connector.getServerInHandlers();
            if (inList != null) {
                for (int i = 0; i < inList.size(); ++i) {
                    Class clazz = ClassUtils.loadClass((String)inList.get(i).toString(), ((Object)((Object)this)).getClass());
                    Handler handler = (Handler)clazz.getConstructor(null).newInstance(null);
                    this.service.addInHandler(handler);
                }
            }
            boolean sync = this.endpoint.isSynchronous();
            if (this.endpoint.getEndpointURI().getScheme().startsWith("http") || this.endpoint.getEndpointURI().getScheme().startsWith("servlet")) {
                sync = true;
            }
            this.service.setInvoker((Invoker)new MuleInvoker(this, sync));
        }
        catch (Exception e) {
            throw new CreateException((Throwable)e, (Object)this);
        }
    }

    protected void doDispose() {
    }

    public void doConnect() throws Exception {
        this.connector.getXfire().getServiceRegistry().register(this.service);
        this.connector.registerReceiverWithMuleService((UMOMessageReceiver)this, this.endpoint.getEndpointURI());
    }

    public void doDisconnect() throws Exception {
        this.connector.getXfire().getServiceRegistry().unregister(this.service);
    }

    public void doStart() throws UMOException {
    }

    public void doStop() throws UMOException {
    }

    protected void rewriteProperty(Map props, String name) {
        if (props.containsKey(name)) {
            Object temp = props.remove(name);
            props.put("objectServiceFactory." + name, temp);
        }
    }
}

