/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.xfire;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceRegistry;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.transport.http.HtmlServiceWriter;
import org.mule.config.i18n.MessageFactory;
import org.mule.impl.MuleMessage;
import org.mule.providers.soap.xfire.XFireMessageReceiver;
import org.mule.providers.soap.xfire.transport.MuleLocalChannel;
import org.mule.providers.streaming.OutStreamMessageAdapter;
import org.mule.providers.streaming.StreamMessageAdapter;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.lifecycle.Callable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.Lifecycle;
import org.mule.umo.provider.UMOStreamMessageAdapter;
import org.mule.util.StringUtils;

public class XFireServiceComponent
implements Callable,
Initialisable,
Lifecycle {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected XFire xfire;
    protected Transport transport;
    protected String transportClass;

    public XFireServiceComponent(XFireMessageReceiver receiver) {
    }

    public Object onCall(UMOEventContext eventContext) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)eventContext);
        }
        boolean wsdlRequested = false;
        String request = eventContext.getMessage().getStringProperty("http.request", "");
        if (request.toLowerCase().endsWith("wsdl")) {
            wsdlRequested = true;
        } else {
            Enumeration<Object> keys = eventContext.getEndpointURI().getParams().keys();
            while (keys.hasMoreElements()) {
                if (!keys.nextElement().toString().equalsIgnoreCase("wsdl")) continue;
                wsdlRequested = true;
                break;
            }
        }
        if (wsdlRequested) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.getXfire().generateWSDL(this.getServiceName(eventContext), (OutputStream)out);
            MuleMessage result = new MuleMessage((Object)out.toString(eventContext.getEncoding()));
            result.setProperty("Content-Type", (Object)"text/xml");
            return result;
        }
        if (this.transport == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"transport is null, this service has not been initialized properly"), (Initialisable)this);
        }
        MuleLocalChannel channel = (MuleLocalChannel)this.transport.createChannel(eventContext.getEndpointURI().getFullScheme());
        return channel.onCall(eventContext);
    }

    public void start() throws UMOException {
    }

    public void stop() throws UMOException {
    }

    public void initialise() throws InitialisationException {
        if (this.xfire == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"No XFire instance, this component has not been initialized properly."), (Initialisable)this);
        }
    }

    public void dispose() {
    }

    protected TransportManager getTransportManager() {
        return this.getXfire().getTransportManager();
    }

    protected void generateServiceX(OutStreamMessageAdapter response, String serviceName) throws IOException, XMLStreamException {
        response.setProperty("Content-Type", (Object)"text/html");
        Service endpoint = this.getServiceRegistry().getService(serviceName);
        HtmlServiceWriter writer = new HtmlServiceWriter();
        writer.write(response.getStream(), endpoint);
    }

    protected void generateServicesX(OutStreamMessageAdapter response) throws IOException, XMLStreamException {
        response.setProperty("Content-Type", (Object)"text/html");
        HtmlServiceWriter writer = new HtmlServiceWriter();
        writer.write(response.getStream(), this.getServiceRegistry().getServices());
    }

    protected InputStream getMessageStream(UMOEventContext context) throws UMOException {
        InputStream is;
        UMOMessage eventMsg = context.getMessage();
        Object eventMsgPayload = eventMsg.getPayload();
        if (eventMsgPayload instanceof InputStream) {
            is = (InputStream)eventMsgPayload;
        } else if (eventMsg.getAdapter() instanceof UMOStreamMessageAdapter) {
            StreamMessageAdapter sma = (StreamMessageAdapter)eventMsg.getAdapter();
            is = sma.getInputStream();
        } else {
            is = new ByteArrayInputStream(context.getTransformedMessageAsBytes());
        }
        return is;
    }

    protected String getServiceName(UMOEventContext context) {
        String pathInfo = context.getEndpointURI().getPath();
        if (StringUtils.isEmpty((String)pathInfo)) {
            return context.getEndpointURI().getHost();
        }
        int i = pathInfo.lastIndexOf("/");
        String serviceName = i > -1 ? pathInfo.substring(i + 1) : pathInfo;
        return serviceName;
    }

    protected Service getService(String name) {
        return this.getXfire().getServiceRegistry().getService(name);
    }

    public XFire getXfire() {
        return this.xfire;
    }

    public void setXfire(XFire xfire) {
        this.xfire = xfire;
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public void setTransportClass(String clazz) {
        this.transportClass = clazz;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.xfire.getServiceRegistry();
    }
}

