/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.xfire.transport;

import edu.emory.mathcs.backport.java.util.concurrent.Semaphore;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.exchange.AbstractMessage;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.AbstractChannel;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.Session;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.util.STAXUtils;
import org.mule.MuleException;
import org.mule.impl.message.ExceptionPayload;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOException;
import org.mule.umo.UMOExceptionPayload;
import org.mule.umo.UMOMessage;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.util.StringUtils;

public class MuleLocalChannel
extends AbstractChannel {
    protected static final String SENDER_URI = "senderUri";
    protected static final String OLD_CONTEXT = "urn:xfire:transport:local:oldContext";
    protected transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Session session;
    protected UMOWorkManager workManager;

    public MuleLocalChannel(String uri, Transport transport, Session session) {
        this.session = session;
        this.setUri(uri);
        this.setTransport(transport);
    }

    public void open() {
    }

    public void send(MessageContext context, OutMessage message) throws XFireException {
        if (message.getUri().equals("urn:xfire:channel:backchannel")) {
            OutputStream out = (OutputStream)context.getProperty("urn:xfire:channel:backchannel");
            if (out != null) {
                XMLStreamWriter writer = STAXUtils.createXMLStreamWriter((OutputStream)out, (String)message.getEncoding(), (MessageContext)context);
                message.getSerializer().writeMessage(message, writer, context);
            } else {
                MessageContext oldContext = (MessageContext)context.getProperty(OLD_CONTEXT);
                this.sendViaNewChannel(context, oldContext, message, (String)context.getProperty(SENDER_URI));
            }
        } else {
            MessageContext receivingContext = new MessageContext();
            receivingContext.setXFire(context.getXFire());
            receivingContext.setService(this.getService(context.getXFire(), message.getUri()));
            receivingContext.setProperty(OLD_CONTEXT, (Object)context);
            receivingContext.setProperty(SENDER_URI, (Object)this.getUri());
            receivingContext.setSession(this.session);
            this.sendViaNewChannel(context, receivingContext, message, message.getUri());
        }
    }

    protected Service getService(XFire xfire, String uri) throws XFireException {
        if (null == xfire) {
            this.logger.warn((Object)"No XFire instance in context, unable to determine service");
            return null;
        }
        int i = uri.indexOf("//");
        if (i == -1) {
            throw new XFireException("Malformed service URI");
        }
        String name = uri.substring(i + 2);
        Service service = xfire.getServiceRegistry().getService(name);
        if (null == service) {
            this.logger.warn((Object)("Unable to locate '" + name + "' in ServiceRegistry"));
        }
        return service;
    }

    private void sendViaNewChannel(MessageContext context, MessageContext receivingContext, OutMessage message, String uri) throws XFireException {
        try {
            Channel channel;
            PipedInputStream stream = new PipedInputStream();
            PipedOutputStream outStream = new PipedOutputStream(stream);
            try {
                channel = this.getTransport().createChannel(uri);
            }
            catch (Exception e) {
                throw new XFireException("Couldn't create channel.", (Throwable)e);
            }
            Semaphore s = new Semaphore(2);
            try {
                this.getWorkManager().scheduleWork((Work)new WriterWorker(outStream, message, context, s));
                this.getWorkManager().scheduleWork((Work)new ReaderWorker(stream, message, channel, uri, receivingContext, s));
            }
            catch (WorkException e) {
                throw new XFireException("Couldn't schedule worker threads. " + e.getMessage(), (Throwable)e);
            }
            try {
                s.acquire();
            }
            catch (InterruptedException e) {}
        }
        catch (IOException e) {
            throw new XFireRuntimeException("Couldn't create stream.", (Throwable)e);
        }
    }

    public void close() {
    }

    public boolean isAsync() {
        return true;
    }

    public UMOWorkManager getWorkManager() {
        return this.workManager;
    }

    public void setWorkManager(UMOWorkManager workManager) {
        this.workManager = workManager;
    }

    protected String getService(UMOEventContext context) {
        String pathInfo = context.getEndpointURI().getPath();
        if (StringUtils.isEmpty((String)pathInfo)) {
            return context.getEndpointURI().getHost();
        }
        int i = pathInfo.lastIndexOf("/");
        String serviceName = i > -1 ? pathInfo.substring(i + 1) : pathInfo;
        return serviceName;
    }

    public Object onCall(UMOEventContext ctx) throws UMOException {
        try {
            XMLStreamReader reader;
            MessageContext context = new MessageContext();
            XFire xfire = (XFire)ctx.getComponent().getProperties().get("xfire");
            context.setService(xfire.getServiceRegistry().getService(this.getService(ctx)));
            context.setXFire(xfire);
            ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
            context.setProperty("urn:xfire:channel:backchannel", (Object)resultStream);
            Object payload = ctx.getMessage().getPayload();
            if (payload instanceof InputStream) {
                reader = STAXUtils.createXMLStreamReader((InputStream)((InputStream)payload), (String)ctx.getEncoding(), (MessageContext)context);
            } else if (payload instanceof Reader) {
                reader = STAXUtils.createXMLStreamReader((Reader)((Reader)payload), (MessageContext)context);
            } else {
                String text = ctx.getTransformedMessageAsString(ctx.getEncoding());
                reader = STAXUtils.createXMLStreamReader((Reader)new StringReader(text), (MessageContext)context);
            }
            InMessage in = new InMessage(reader, this.getUri());
            String soapAction = this.getSoapAction(ctx.getMessage());
            in.setProperty((Object)"SOAPAction", (Object)soapAction);
            this.receive(context, in);
            String result = null;
            try {
                AbstractMessage fault = context.getExchange().getFaultMessage();
                if (fault != null && fault.getBody() != null) {
                    result = resultStream.toString(fault.getEncoding());
                    ExceptionPayload exceptionPayload = new ExceptionPayload((Throwable)new Exception(result.toString()));
                    ctx.getMessage().setExceptionPayload((UMOExceptionPayload)exceptionPayload);
                } else if (context.getExchange().hasOutMessage()) {
                    result = resultStream.toString(context.getExchange().getOutMessage().getEncoding());
                }
            }
            catch (UnsupportedEncodingException e1) {
                throw new MuleException((Throwable)e1);
            }
            return result;
        }
        catch (UMOException e) {
            this.logger.warn((Object)"Could not dispatch message to XFire!", (Throwable)e);
            throw e;
        }
    }

    private String getSoapAction(UMOMessage message) {
        String action = (String)message.getProperty("SOAPAction");
        if (action != null && action.startsWith("\"") && action.endsWith("\"") && action.length() >= 2) {
            action = action.substring(1, action.length() - 1);
        }
        return action;
    }

    private class WriterWorker
    implements Work {
        private OutputStream stream;
        private OutMessage message;
        private MessageContext context;
        private Semaphore semaphore;

        public WriterWorker(OutputStream stream, OutMessage message, MessageContext context, Semaphore semaphore) {
            this.stream = stream;
            this.message = message;
            this.context = context;
            this.semaphore = semaphore;
        }

        public void run() {
            try {
                XMLStreamWriter writer = STAXUtils.createXMLStreamWriter((OutputStream)this.stream, (String)this.message.getEncoding(), (MessageContext)this.context);
                this.message.getSerializer().writeMessage(this.message, writer, this.context);
                writer.close();
                this.stream.close();
            }
            catch (Exception e) {
                throw new XFireRuntimeException("Couldn't write stream.", (Throwable)e);
            }
            finally {
                this.semaphore.release();
            }
        }

        public void release() {
        }
    }

    private class ReaderWorker
    implements Work {
        private InputStream stream;
        private OutMessage message;
        private Channel channel;
        private String uri;
        private MessageContext context;
        private Semaphore semaphore;

        public ReaderWorker(InputStream stream, OutMessage message, Channel channel, String uri, MessageContext context, Semaphore semaphore) {
            this.stream = stream;
            this.message = message;
            this.channel = channel;
            this.uri = uri;
            this.context = context;
            this.semaphore = semaphore;
        }

        public void run() {
            try {
                XMLStreamReader reader = STAXUtils.createXMLStreamReader((InputStream)this.stream, (String)this.message.getEncoding(), (MessageContext)this.context);
                InMessage inMessage = new InMessage(reader, this.uri);
                inMessage.setEncoding(this.message.getEncoding());
                this.channel.receive(this.context, inMessage);
                reader.close();
                this.stream.close();
            }
            catch (Exception e) {
                throw new XFireRuntimeException("Couldn't read stream.", (Throwable)e);
            }
            finally {
                this.semaphore.release();
            }
        }

        public void release() {
        }
    }
}

