/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.xfire;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceRegistry;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.transport.http.HtmlServiceWriter;
import org.mule.config.i18n.MessageFactory;
import org.mule.impl.MuleMessage;
import org.mule.providers.soap.xfire.XFireMessageReceiver;
import org.mule.providers.soap.xfire.transport.MuleLocalChannel;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOException;
import org.mule.umo.lifecycle.Callable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.Lifecycle;
import org.mule.util.StringUtils;

public class XFireServiceComponent
implements Callable,
Lifecycle {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected XFire xfire;
    protected Transport transport;
    protected String transportClass;

    public XFireServiceComponent(XFireMessageReceiver receiver) {
    }

    public Object onCall(UMOEventContext eventContext) throws Exception {
        ByteArrayOutputStream out;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)eventContext);
        }
        boolean wsdlRequested = false;
        boolean servicesRequested = false;
        String request = eventContext.getMessage().getStringProperty("http.request", "");
        if (request.toLowerCase().endsWith("wsdl")) {
            wsdlRequested = true;
        } else if (request.toLowerCase().endsWith("list")) {
            servicesRequested = true;
        } else {
            Enumeration<Object> keys = eventContext.getEndpointURI().getParams().keys();
            while (keys.hasMoreElements()) {
                if (!keys.nextElement().toString().equalsIgnoreCase("wsdl")) continue;
                wsdlRequested = true;
                break;
            }
        }
        if (wsdlRequested) {
            out = new ByteArrayOutputStream();
            this.getXfire().generateWSDL(this.getServiceName(eventContext), (OutputStream)out);
            MuleMessage result = new MuleMessage((Object)out.toString(eventContext.getEncoding()));
            result.setProperty("Content-Type", (Object)"text/xml");
            return result;
        }
        if (servicesRequested) {
            out = new ByteArrayOutputStream();
            HtmlServiceWriter writer = new HtmlServiceWriter();
            writer.write((OutputStream)out, this.getServiceRegistry().getService(this.getServiceName(eventContext)));
            MuleMessage result = new MuleMessage((Object)out.toString(eventContext.getEncoding()));
            result.setProperty("Content-Type", (Object)"text/xml");
            return result;
        }
        if (this.transport == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"transport is null, this service has not been initialized properly"), (Initialisable)this);
        }
        MuleLocalChannel channel = (MuleLocalChannel)this.transport.createChannel(eventContext.getEndpointURI().getFullScheme());
        return channel.onCall(eventContext);
    }

    public void start() throws UMOException {
    }

    public void stop() throws UMOException {
    }

    public void initialise() throws InitialisationException {
        if (this.xfire == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"No XFire instance, this component has not been initialized properly."), (Initialisable)this);
        }
    }

    public void dispose() {
    }

    protected TransportManager getTransportManager() {
        return this.getXfire().getTransportManager();
    }

    protected InputStream getMessageStream(UMOEventContext context) throws UMOException {
        return (InputStream)context.getMessage().getPayload(InputStream.class);
    }

    protected String getServiceName(UMOEventContext context) {
        String pathInfo = context.getEndpointURI().getPath();
        if (StringUtils.isEmpty((String)pathInfo)) {
            return context.getEndpointURI().getHost();
        }
        int i = pathInfo.lastIndexOf("/");
        String serviceName = i > -1 ? pathInfo.substring(i + 1) : pathInfo;
        return serviceName;
    }

    protected Service getService(String name) {
        return this.getXfire().getServiceRegistry().getService(name);
    }

    public XFire getXfire() {
        return this.xfire;
    }

    public void setXfire(XFire xfire) {
        this.xfire = xfire;
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public void setTransportClass(String clazz) {
        this.transportClass = clazz;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.xfire.getServiceRegistry();
    }
}

