/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.xfire.wsdl;

import java.net.URL;
import javax.xml.namespace.QName;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.service.Service;
import org.mule.providers.AbstractConnectable;
import org.mule.providers.soap.xfire.XFireConnector;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.util.StringUtils;

public class XFireWsdlConnector
extends XFireConnector {
    public static final String WSDL_XFIRE = "wsdl-xfire";

    protected void registerProtocols() {
        this.registerSupportedProtocol("http");
        this.registerSupportedProtocol("https");
        this.registerSupportedProtocolWithoutPrefix("wsdl:http");
        this.registerSupportedProtocolWithoutPrefix("wsdl:https");
    }

    public String getProtocol() {
        return WSDL_XFIRE;
    }

    protected Client doClientConnect(UMOImmutableEndpoint endpoint, AbstractConnectable connectable) throws Exception {
        try {
            Service service;
            XFire xfire = this.getXfire();
            String wsdlUrl = endpoint.getEndpointURI().getAddress();
            String serviceName = endpoint.getEndpointURI().getAddress();
            if (endpoint.getProperty((Object)"wsdlUrl") != null && StringUtils.isNotBlank((String)endpoint.getProperty((Object)"wsdlUrl").toString())) {
                wsdlUrl = (String)endpoint.getProperty((Object)"wsdlUrl");
            }
            if (serviceName.indexOf("?") > -1) {
                serviceName = serviceName.substring(0, serviceName.lastIndexOf(63));
            }
            if ((service = xfire.getServiceRegistry().getService(new QName(serviceName))) == null) {
                service = new Client(new URL(wsdlUrl)).getService();
                service.setName(new QName(serviceName));
                xfire.getServiceRegistry().register(service);
            }
            return this.createXFireWsdlClient(endpoint, service, xfire, wsdlUrl);
        }
        catch (Exception ex) {
            connectable.disconnect();
            throw ex;
        }
    }

    protected Client createXFireWsdlClient(UMOImmutableEndpoint endpoint, Service service, XFire xfire, String wsdlUrl) throws Exception {
        UMOEndpointURI uri = endpoint.getEndpointURI();
        Client client = new Client(new URL(wsdlUrl));
        client.setXFire(xfire);
        client.setEndpointUri(uri.toString());
        return this.configureXFireClient(client);
    }
}

